/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Instance;
import com.hazelcast.impl.AtomicNumberProxy;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.base.FactoryAwareNamedProxy;
import com.hazelcast.impl.monitor.AtomicNumberOperationsCounter;
import com.hazelcast.impl.monitor.LocalAtomicNumberStatsImpl;
import com.hazelcast.monitor.LocalAtomicNumberStats;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;

public class AtomicNumberProxyImpl
extends FactoryAwareNamedProxy
implements AtomicNumberProxy {
    private transient AtomicNumberProxy base = null;
    Data nameAsData = null;

    public AtomicNumberProxyImpl() {
    }

    AtomicNumberProxyImpl(String name, FactoryImpl factory) {
        this.setName(name);
        this.setHazelcastInstance(factory);
        this.base = new AtomicNumberProxyReal();
    }

    Data getNameAsData() {
        if (this.nameAsData == null) {
            this.nameAsData = IOUtil.toData(this.name);
        }
        return this.nameAsData;
    }

    private void ensure() {
        this.factory.initialChecks();
        if (this.base == null) {
            this.base = (AtomicNumberProxy)this.factory.getOrCreateProxyByName(this.name);
        }
    }

    public String toString() {
        return "AtomicLong [" + this.getName() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtomicNumberProxyImpl that = (AtomicNumberProxyImpl)o;
        return !(this.name == null ? that.name != null : !this.name.equals(that.name));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public void destroy() {
        this.ensure();
        this.base.destroy();
    }

    public Instance.InstanceType getInstanceType() {
        this.ensure();
        return this.base.getInstanceType();
    }

    public Object getId() {
        this.ensure();
        return this.base.getId();
    }

    public String getName() {
        this.ensure();
        return this.base.getName();
    }

    public String getLongName() {
        return this.name;
    }

    public long addAndGet(long delta) {
        this.ensure();
        return this.base.addAndGet(delta);
    }

    public boolean compareAndSet(long expect, long update2) {
        this.ensure();
        return this.base.compareAndSet(expect, update2);
    }

    public long decrementAndGet() {
        this.ensure();
        return this.base.decrementAndGet();
    }

    public long get() {
        this.ensure();
        return this.base.get();
    }

    public long getAndAdd(long delta) {
        this.ensure();
        return this.base.getAndAdd(delta);
    }

    public long getAndSet(long newValue) {
        this.ensure();
        return this.base.getAndSet(newValue);
    }

    public long incrementAndGet() {
        this.ensure();
        return this.base.incrementAndGet();
    }

    public void set(long newValue) {
        this.ensure();
        this.base.set(newValue);
    }

    public AtomicNumberOperationsCounter getOperationsCounter() {
        this.ensure();
        return this.base.getOperationsCounter();
    }

    public LocalAtomicNumberStats getLocalAtomicNumberStats() {
        this.ensure();
        return this.base.getLocalAtomicNumberStats();
    }

    @Deprecated
    public void lazySet(long newValue) {
        this.set(newValue);
    }

    @Deprecated
    public boolean weakCompareAndSet(long expect, long update2) {
        return this.compareAndSet(expect, update2);
    }

    private class AtomicNumberProxyReal
    implements AtomicNumberProxy {
        AtomicNumberOperationsCounter operationsCounter = new AtomicNumberOperationsCounter();

        public String getName() {
            return AtomicNumberProxyImpl.this.name.substring("a:".length());
        }

        public String getLongName() {
            return AtomicNumberProxyImpl.this.name;
        }

        public Object getId() {
            return AtomicNumberProxyImpl.this.name;
        }

        public long addAndGet(long delta) {
            return this.newMAtomicNumber().addAndGet(AtomicNumberProxyImpl.this.getNameAsData(), delta);
        }

        public boolean compareAndSet(long expect, long update2) {
            return this.newMAtomicNumber().compareAndSet(AtomicNumberProxyImpl.this.getNameAsData(), expect, update2);
        }

        public long decrementAndGet() {
            return this.addAndGet(-1L);
        }

        public long get() {
            return this.addAndGet(0L);
        }

        public long getAndAdd(long delta) {
            return this.newMAtomicNumber().getAndAdd(AtomicNumberProxyImpl.this.getNameAsData(), delta);
        }

        public long getAndSet(long newValue) {
            return this.newMAtomicNumber().getAndSet(AtomicNumberProxyImpl.this.getNameAsData(), newValue);
        }

        public long incrementAndGet() {
            return this.addAndGet(1L);
        }

        public void set(long newValue) {
            this.getAndSet(newValue);
        }

        public Instance.InstanceType getInstanceType() {
            return Instance.InstanceType.ATOMIC_NUMBER;
        }

        public void destroy() {
            this.newMAtomicNumber().destroy(AtomicNumberProxyImpl.this.getNameAsData());
            AtomicNumberProxyImpl.this.factory.destroyInstanceClusterWide(AtomicNumberProxyImpl.this.name, null);
        }

        public AtomicNumberOperationsCounter getOperationsCounter() {
            return this.operationsCounter;
        }

        public LocalAtomicNumberStats getLocalAtomicNumberStats() {
            LocalAtomicNumberStatsImpl localAtomicStats = new LocalAtomicNumberStatsImpl();
            localAtomicStats.setOperationStats(this.operationsCounter.getPublishedStats());
            return localAtomicStats;
        }

        @Deprecated
        public void lazySet(long newValue) {
            this.set(newValue);
        }

        @Deprecated
        public boolean weakCompareAndSet(long expect, long update2) {
            return this.compareAndSet(expect, update2);
        }

        ConcurrentMapManager.MAtomicNumber newMAtomicNumber() {
            ConcurrentMapManager.MAtomicNumber mAtomicNumber = new ConcurrentMapManager.MAtomicNumber(((AtomicNumberProxyImpl)AtomicNumberProxyImpl.this).factory.node.concurrentMapManager);
            mAtomicNumber.setOperationsCounter(this.operationsCounter);
            return mAtomicNumber;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        }
    }
}

