/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.reader;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;

public class TeeReaderWriter
extends Reader {
    protected final boolean closeStreams;
    protected final boolean[] copyEnabled;
    private long destinationPosition = 0L;
    protected final Writer[] destinations;
    private long markPosition = 0L;
    private long readTime = 0L;
    protected final Reader source;
    private long sourcePosition = 0L;
    private final long[] writeTime;

    public TeeReaderWriter(Reader source, boolean closeStreams, Writer ... destinations) {
        this.source = source;
        if (destinations == null) {
            throw new IllegalArgumentException("Destinations Writer can't be null");
        }
        if (destinations.length == 0) {
            throw new IllegalArgumentException("At least one destination Writer must be specified");
        }
        for (Writer destination : destinations) {
            if (destination != null) continue;
            throw new IllegalArgumentException("One of the Writers in the array is null");
        }
        this.writeTime = new long[destinations.length];
        this.destinations = destinations;
        this.closeStreams = closeStreams;
        this.copyEnabled = new boolean[destinations.length];
        Arrays.fill(this.copyEnabled, true);
    }

    public TeeReaderWriter(Reader source, Writer destination) {
        this(source, destination, true);
    }

    public TeeReaderWriter(Reader source, Writer destination, boolean closeStreams) {
        this(source, closeStreams, destination);
    }

    public void close() throws IOException {
        IOException e1 = null;
        try {
            char[] buffer = new char[8192];
            while (this.read(buffer, 0, buffer.length) > 0) {
            }
        }
        catch (IOException e2) {
            e1 = new IOException("Incomplete data was written to the destination Writer(s).");
            e1.initCause(e2);
        }
        if (this.closeStreams) {
            long startr = System.currentTimeMillis();
            this.source.close();
            this.readTime += System.currentTimeMillis() - startr;
            int i = 0;
            while (i < this.destinations.length) {
                long start = System.currentTimeMillis();
                this.destinations[i].close();
                int n = i++;
                this.writeTime[n] = this.writeTime[n] + (System.currentTimeMillis() - start);
            }
        }
        if (e1 != null) {
            throw e1;
        }
    }

    public final void enableCopy(boolean enable) {
        Arrays.fill(this.copyEnabled, enable);
    }

    public final void enableCopy(boolean[] enable) {
        if (enable == null) {
            throw new IllegalArgumentException("Enable array can't be null");
        }
        if (enable.length != this.copyEnabled.length) {
            throw new IllegalArgumentException("Enable array must be of the same size of the Writer array passed in the constructor. Array size [" + enable.length + "] streams [" + this.copyEnabled.length + "]");
        }
        for (int i = 0; i < enable.length; ++i) {
            this.copyEnabled[i] = enable[i];
        }
    }

    public long getReadTime() {
        return this.readTime;
    }

    public long getWriteSize() {
        return this.destinationPosition;
    }

    public long[] getWriteTime() {
        return this.writeTime;
    }

    public void mark(int readLimit) throws IOException {
        this.source.mark(readLimit);
        this.markPosition = this.sourcePosition;
    }

    public boolean markSupported() {
        return this.source.markSupported();
    }

    public int read() throws IOException {
        long startr = System.currentTimeMillis();
        int result = this.source.read();
        this.readTime += System.currentTimeMillis() - startr;
        if (result >= 0) {
            ++this.sourcePosition;
            if (this.sourcePosition > this.destinationPosition) {
                for (int i = 0; i < this.destinations.length; ++i) {
                    if (!this.copyEnabled[i]) continue;
                    long start = System.currentTimeMillis();
                    this.destinations[i].write(result);
                    long[] lArray = this.getWriteTime();
                    int n = i;
                    lArray[n] = lArray[n] + (System.currentTimeMillis() - start);
                }
                ++this.destinationPosition;
            }
        }
        return result;
    }

    public int read(char[] b, int off, int len) throws IOException {
        long startr = System.currentTimeMillis();
        int result = this.source.read(b, off, len);
        this.readTime += System.currentTimeMillis() - startr;
        if (result > 0) {
            if (this.sourcePosition + (long)result > this.destinationPosition) {
                int newLen = (int)(this.sourcePosition + (long)result - this.destinationPosition);
                int newOff = off + (result - newLen);
                for (int i = 0; i < this.destinations.length; ++i) {
                    if (!this.copyEnabled[i]) continue;
                    long start = System.currentTimeMillis();
                    this.destinations[i].write(b, newOff, newLen);
                    long[] lArray = this.getWriteTime();
                    int n = i;
                    lArray[n] = lArray[n] + (System.currentTimeMillis() - start);
                }
                this.destinationPosition += (long)newLen;
            }
            this.sourcePosition += (long)result;
        }
        return result;
    }

    public synchronized void reset() throws IOException {
        this.source.reset();
        this.sourcePosition = this.markPosition;
    }
}

