/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.ColumnNameCache;
import org.hibernate.util.JDBCExceptionReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetWrapperProxy
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(ResultSetWrapperProxy.class);
    private static final Class[] PROXY_INTERFACES = new Class[]{ResultSet.class};
    private final ResultSet rs;
    private final ColumnNameCache columnNameCache;

    private ResultSetWrapperProxy(ResultSet rs, ColumnNameCache columnNameCache) {
        this.rs = rs;
        this.columnNameCache = columnNameCache;
    }

    public static ResultSet generateProxy(ResultSet resultSet, ColumnNameCache columnNameCache) {
        return (ResultSet)Proxy.newProxyInstance(ResultSetWrapperProxy.getProxyClassLoader(), PROXY_INTERFACES, (InvocationHandler)new ResultSetWrapperProxy(resultSet, columnNameCache));
    }

    public static ClassLoader getProxyClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ResultSet.class.getClassLoader();
        }
        return cl;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        block5: {
            if ("findColumn".equals(method.getName())) {
                return new Integer(this.findColumn((String)args[0]));
            }
            if (this.isFirstArgColumnLabel(method, args)) {
                try {
                    int columnIndex = this.findColumn((String)args[0]);
                    return this.invokeMethod(this.locateCorrespondingColumnIndexMethod(method), this.buildColumnIndexMethodArgs(args, columnIndex));
                }
                catch (SQLException ex) {
                    StringBuffer buf = new StringBuffer().append("Exception getting column index for column: [").append(args[0]).append("].\nReverting to using: [").append(args[0]).append("] as first argument for method: [").append(method).append("]");
                    JDBCExceptionReporter.logExceptions(ex, buf.toString());
                }
                catch (NoSuchMethodException ex) {
                    StringBuffer buf = new StringBuffer().append("Exception switching from method: [").append(method).append("] to a method using the column index. Reverting to using: [").append(method).append("]");
                    if (!log.isWarnEnabled()) break block5;
                    log.warn(buf.toString());
                }
            }
        }
        return this.invokeMethod(method, args);
    }

    private int findColumn(String columnName) throws SQLException {
        return this.columnNameCache.getIndexForColumnName(columnName, this.rs);
    }

    private boolean isFirstArgColumnLabel(Method method, Object[] args) {
        if (!method.getName().startsWith("get") && !method.getName().startsWith("update")) {
            return false;
        }
        if (method.getParameterTypes().length <= 0 || args.length != method.getParameterTypes().length) {
            return false;
        }
        return String.class.isInstance(args[0]) && method.getParameterTypes()[0].equals(String.class);
    }

    private Method locateCorrespondingColumnIndexMethod(Method columnNameMethod) throws NoSuchMethodException {
        Class[] actualParameterTypes = new Class[columnNameMethod.getParameterTypes().length];
        actualParameterTypes[0] = Integer.TYPE;
        System.arraycopy(columnNameMethod.getParameterTypes(), 1, actualParameterTypes, 1, columnNameMethod.getParameterTypes().length - 1);
        return columnNameMethod.getDeclaringClass().getMethod(columnNameMethod.getName(), actualParameterTypes);
    }

    private Object[] buildColumnIndexMethodArgs(Object[] incomingArgs, int columnIndex) {
        Object[] actualArgs = new Object[incomingArgs.length];
        actualArgs[0] = new Integer(columnIndex);
        System.arraycopy(incomingArgs, 1, actualArgs, 1, incomingArgs.length - 1);
        return actualArgs;
    }

    private Object invokeMethod(Method method, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)this.rs, args);
        }
        catch (InvocationTargetException e2) {
            throw e2.getTargetException();
        }
    }
}

