/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.log;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.dataone.cn.log.MetricEvent;
import org.dataone.cn.log.MetricLogClient;
import org.dataone.cn.log.MetricLogClientFactory;
import org.dataone.cn.log.MetricLogEntry;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricLogEntryTest {
    private static final Logger log = LoggerFactory.getLogger(MetricLogEntryTest.class);
    MetricLogClient metricLogClient = MetricLogClientFactory.getMetricLogClient();
    private static final String JSON_START_TOKEN = "^\\{";
    private static final String JSON_END_TOKEN = "\\}$";
    private static final String SYNC_QUEUED_TOKEN = "\\\"event\\\"\\:\\\"synchronization\\squeued\\\"\\,";
    private static final String DATE_LOGGED_TOKEN = "\\\"dateLogged\\\"\\:\\\"\\d{4}\\-\\d{2}\\-\\d{2}T\\d{2}\\:\\d{2}\\:\\d{2}\\.\\d{3}(?:(?:[\\+\\-]\\d\\d:\\d\\d)|Z)\\\"";
    private static final String THREAD_TOKEN = "\"threadName\"\\:\"\\w+\"\\,\"threadId\"\\:\\d+,";

    @Test
    public void testMinimalValidMetricLogEntry() {
        String minJsonRegex = "^\\{\\\"event\\\"\\:\\\"synchronization\\squeued\\\"\\,\"threadName\"\\:\"\\w+\"\\,\"threadId\"\\:\\d+,\\\"dateLogged\\\"\\:\\\"\\d{4}\\-\\d{2}\\-\\d{2}T\\d{2}\\:\\d{2}\\:\\d{2}\\.\\d{3}(?:(?:[\\+\\-]\\d\\d:\\d\\d)|Z)\\\"\\}$";
        Pattern minJsonPattern = Pattern.compile(minJsonRegex);
        MetricLogEntry minMetricLogEntry = new MetricLogEntry(MetricEvent.SYNCHRONIZATION_QUEUED);
        String json = minMetricLogEntry.toString();
        this.metricLogClient.logMetricEvent(minMetricLogEntry);
        log.info(json);
        Matcher jsonMatcher = minJsonPattern.matcher(json);
        Assert.assertTrue(jsonMatcher.matches());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFailedMetricLogEntry() {
        MetricLogEntry minMetricLogEntry = new MetricLogEntry(null);
    }
}

