/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.v2.formats;

import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.ObjectFormatList;
import org.dataone.service.types.v2.util.ObjectFormatServiceImpl;

public class ObjectFormatCache {
    private static Logger logger = Logger.getLogger(ObjectFormatCache.class.getName());
    private static ObjectFormatCache objectFormatCache;
    private ObjectFormatList objectFormatList;
    private ConcurrentHashMap<ObjectFormatIdentifier, ObjectFormat> objectFormatMap = new ConcurrentHashMap();
    public static boolean usingFallbackFormatList;
    protected static int throttleIntervalSec;
    protected Date lastRefreshDate = new Date(0L);

    private ObjectFormatCache() {
        throttleIntervalSec = Settings.getConfiguration().getInt("ObjectFormatCache.minimum.refresh.interval.seconds", throttleIntervalSec);
        try {
            this.refreshCache();
        }
        catch (ServiceFailure e2) {
            logger.error("Failed to get a ObjectFormatList from the CN or the default one shipped with d1_libclient_java package. Cause = ServiceFailure::" + e2.getDetail_code() + ": " + e2.getDescription(), e2);
            RuntimeException re = new RuntimeException("Serious problem populating the ObjectFormatCache. Halting.");
            re.initCause(e2);
            throw re;
        }
    }

    public static ObjectFormatCache getInstance() {
        return ObjectFormatCacheSingleton.instance;
    }

    public ObjectFormatList listFormats() {
        if (usingFallbackFormatList) {
            try {
                this.refreshCache();
            }
            catch (ServiceFailure serviceFailure) {
                // empty catch block
            }
        }
        return this.objectFormatList;
    }

    public int getMinimalRefreshInterval() {
        return throttleIntervalSec;
    }

    public Date getLastRefreshDate() {
        return this.lastRefreshDate;
    }

    public boolean isUsingFallbackFormatList() {
        return usingFallbackFormatList;
    }

    protected synchronized void refreshCache() throws ServiceFailure {
        Date now2 = new Date();
        ObjectFormatList newObjectFormatList = null;
        logger.info("entering refreshCache()...");
        if (usingFallbackFormatList || now2.getTime() - this.lastRefreshDate.getTime() > (long)(throttleIntervalSec * 1000)) {
            CNode cn = null;
            String cnUrl = Settings.getConfiguration().getString("ObjectFormatCache.overriding.CN_URL");
            if (StringUtils.isBlank(cnUrl)) {
                cnUrl = Settings.getConfiguration().getString("D1Client.CN_URL");
            }
            try {
                if (StringUtils.isBlank(cnUrl)) {
                    throw new ServiceFailure("0-client-side", "Null D1Client.CN_URL: " + cnUrl);
                }
                cn = D1Client.getCN(cnUrl);
                logger.info("refreshing objectFormatCache from cn: " + cn.getNodeId());
                newObjectFormatList = cn.listFormats();
                usingFallbackFormatList = false;
                this.lastRefreshDate = new Date();
            }
            catch (NotImplemented | ServiceFailure e2) {
                logger.warn("Could not refresh ObjectFormat cache from CN: " + cnUrl);
                if (usingFallbackFormatList) {
                    logger.warn("Will temporarily use the locally cached list.");
                    try {
                        newObjectFormatList = ObjectFormatServiceImpl.getInstance().listFormats();
                    }
                    catch (ServiceFailure e1) {
                        logger.error("Could not get the local ObjectFormatList file shipped with the jar!!");
                        throw e1;
                    }
                }
                logger.warn("Using stale objectFormatList...");
            }
            if (newObjectFormatList != null) {
                if (this.getObjectFormatMap() != null) {
                    this.getObjectFormatMap().clear();
                }
                for (ObjectFormat objectFormat : newObjectFormatList.getObjectFormatList()) {
                    this.getObjectFormatMap().put(objectFormat.getFormatId(), objectFormat);
                }
                this.objectFormatList = newObjectFormatList;
                if (usingFallbackFormatList) {
                    logger.info("refreshed cache from format list shipped with libclient_java.");
                } else {
                    logger.info("successfully refreshed cache from cn.listFormats()");
                }
            }
        } else {
            logger.info("cache is still fresh. exiting without refresh.");
        }
    }

    @Deprecated
    public ObjectFormat getFormat(String fmtidStr) throws NotFound {
        ObjectFormatIdentifier formatId = new ObjectFormatIdentifier();
        formatId.setValue(fmtidStr);
        return this.getFormat(formatId);
    }

    public ObjectFormat getFormat(ObjectFormatIdentifier formatId) throws NotFound {
        ObjectFormat objectFormat;
        ObjectFormat objectFormat2 = objectFormat = usingFallbackFormatList ? null : this.getObjectFormatMap().get(formatId);
        if (objectFormat == null) {
            try {
                this.refreshCache();
            }
            catch (ServiceFailure serviceFailure) {
                // empty catch block
            }
            objectFormat = this.getObjectFormatMap().get(formatId);
        }
        if (objectFormat == null) {
            throw new NotFound("0000", "The format specified by " + formatId.getValue() + " was not found after refreshing the cache.");
        }
        return objectFormat;
    }

    protected ConcurrentHashMap<ObjectFormatIdentifier, ObjectFormat> getObjectFormatMap() {
        return this.objectFormatMap;
    }

    static {
        usingFallbackFormatList = true;
        throttleIntervalSec = 20;
    }

    private static class ObjectFormatCacheSingleton {
        public static final ObjectFormatCache instance = new ObjectFormatCache();

        private ObjectFormatCacheSingleton() {
        }
    }
}

