/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites.optimizer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.Histogram;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.ProbabilityFactory;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.Pattern;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityIndex;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityIndexModel;
import com.hp.hpl.jena.sparql.suites.optimizer.Util;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestIndex
extends TestCase {
    private static Model graphM = null;
    private static ProbabilityIndex index = null;
    private static ProbabilityIndexModel probability = null;
    private static Map properties = null;
    private static Map histograms = null;
    private static Map patterns = null;
    private static final String testDataFileName = "testing/Optimizer/Test-data.n3";

    public TestIndex(String title) {
        super(title);
    }

    public static void oneTimeSetUp() {
        graphM = Util.readModel(testDataFileName);
        probability = (ProbabilityIndexModel)ProbabilityFactory.createIndexModel(Util.readModel(testDataFileName));
        index = probability.getIndex();
        properties = index.getProperties();
        histograms = index.getHistograms();
        patterns = index.getPatterns();
    }

    public static void oneTimeTearDown() {
        graphM.close();
    }

    public void testDataGraphSize() {
        TestIndex.assertEquals(probability.getDataGraphSize(), 37L);
    }

    public void testIndexedSize() {
        TestIndex.assertEquals(probability.getIndexedSize(), 37L);
    }

    public void testMinProbability() {
        TestIndex.assertEquals(probability.getMinProbability(), 0.02702702702702703, 0.0);
    }

    public void testMinJoinedProbability() {
        TestIndex.assertEquals(probability.getMinJoinedProbability(), 7.304601899196494E-4, 0.0);
    }

    public void testSquaredDataGraphSize() {
        TestIndex.assertEquals((double)probability.getSquaredDataGraphSize(), 1369.0, 0.0);
    }

    public void testSquaredIndexedSize() {
        TestIndex.assertEquals((double)probability.getSquaredIndexedSize(), 1369.0, 0.0);
    }

    public void testIndexAllowsJoinedProbability() {
        TestIndex.assertTrue(index.allowsJoinedProbability());
    }

    public void testIndexLevel() {
        TestIndex.assertEquals(index.getLevel(), 1);
    }

    public void testNumOfIndexedResources() {
        TestIndex.assertEquals(index.getIndexedNumRes(), 5L);
    }

    public void testIndexedSSSize() {
        TestIndex.assertEquals(index.getIndexedSSSize(), 303L);
    }

    public void testIndexedSOSize() {
        TestIndex.assertEquals(index.getIndexedSOSize(), 0L);
    }

    public void testIndexedOSSize() {
        TestIndex.assertEquals(index.getIndexedOSSize(), 0L);
    }

    public void testIndexedOOSize() {
        TestIndex.assertEquals(index.getIndexedOOSize(), 63L);
    }

    public void testNumOfIndexedProperties() {
        TestIndex.assertEquals(properties.size(), 9);
    }

    public void testPropertyLookup1() {
        Property property = ResourceFactory.createProperty("http://example.org#firstname");
        TestIndex.assertEquals((Long)properties.get(property), 5L);
        TestIndex.assertEquals(index.lookup(property), 5L);
    }

    public void testPropertyLookup2() {
        Property property = ResourceFactory.createProperty("http://example.org#lastname");
        TestIndex.assertEquals((Long)properties.get(property), 5L);
        TestIndex.assertEquals(index.lookup(property), 5L);
    }

    public void testPropertyLookup3() {
        Property property = ResourceFactory.createProperty("http://example.org#msn");
        TestIndex.assertEquals((Long)properties.get(property), 3L);
        TestIndex.assertEquals(index.lookup(property), 3L);
    }

    public void testPropertyLookup4() {
        Property property = ResourceFactory.createProperty("http://example.org#skype");
        TestIndex.assertEquals((Long)properties.get(property), 4L);
        TestIndex.assertEquals(index.lookup(property), 4L);
    }

    public void testPropertyLookup5() {
        Property property = ResourceFactory.createProperty("http://example.org#Workplace");
        TestIndex.assertEquals(index.lookup(property), 0L);
    }

    public void testNumOfIndexedHistograms() {
        TestIndex.assertEquals(histograms.size(), properties.size());
    }

    public void testHistogram1() {
        Property property = ResourceFactory.createProperty("http://example.org#firstname");
        Histogram histogram = (Histogram)histograms.get(property);
        TestIndex.assertEquals(histogram.size(), 5L);
        TestIndex.assertEquals(histogram.getClassSize(), 0.4, 0.0);
        TestIndex.assertEquals(histogram.getLowerBound(), -9.18128756E8, 0.0);
        TestIndex.assertEquals(histogram.getUpperBound(), -9.18128752E8, 0.0);
        TestIndex.assertEquals(histogram.getClasses().size(), 10);
    }

    public void testHistogram2() {
        Property property = ResourceFactory.createProperty("http://example.org#lastname");
        Histogram histogram = (Histogram)histograms.get(property);
        TestIndex.assertEquals(histogram.size(), 5L);
        TestIndex.assertEquals(histogram.getClassSize(), 0.4, 0.0);
        TestIndex.assertEquals(histogram.getLowerBound(), -1.746240346E9, 0.0);
        TestIndex.assertEquals(histogram.getUpperBound(), -1.746240342E9, 0.0);
        TestIndex.assertEquals(histogram.getClasses().size(), 10);
    }

    public void testHistogram3() {
        Property property = ResourceFactory.createProperty("http://example.org#msn");
        Histogram histogram = (Histogram)histograms.get(property);
        TestIndex.assertEquals(histogram.size(), 3L);
        TestIndex.assertEquals(histogram.getClassSize(), 2.487512833E8, 0.0);
        TestIndex.assertEquals(histogram.getLowerBound(), -5.9668676E8, 0.0);
        TestIndex.assertEquals(histogram.getUpperBound(), 1.890826073E9, 0.0);
        TestIndex.assertEquals(histogram.getClasses().size(), 10);
    }

    public void testHistogram4() {
        Property property = ResourceFactory.createProperty("http://example.org#skype");
        Histogram histogram = (Histogram)histograms.get(property);
        TestIndex.assertEquals(histogram.size(), 4L);
        TestIndex.assertEquals(histogram.getClassSize(), 1.121603817E8, 0.0);
        TestIndex.assertEquals(histogram.getLowerBound(), -6.78441091E8, 0.0);
        TestIndex.assertEquals(histogram.getUpperBound(), 4.43162726E8, 0.0);
        TestIndex.assertEquals(histogram.getClasses().size(), 10);
    }

    public void testHistogramClass1() {
        Property property = ResourceFactory.createProperty("http://example.org#firstname");
        Histogram histogram = (Histogram)histograms.get(property);
        TestIndex.assertEquals(histogram.getClassFrequency(Node.createLiteral("First Name 1")), 1L);
        TestIndex.assertEquals(histogram.getClassFrequency(Node.createLiteral("First Name 2")), 1L);
        TestIndex.assertEquals(histogram.getClassFrequency(Node.createLiteral("First Name 10")), 0L);
    }

    public void testHistogramClass2() {
        Property property = ResourceFactory.createProperty("http://example.org#lastname");
        Histogram histogram = (Histogram)histograms.get(property);
        TestIndex.assertEquals(histogram.getClassFrequency(Node.createLiteral("Last Name 1")), 1L);
        TestIndex.assertEquals(histogram.getClassFrequency(Node.createLiteral("Last Name 2")), 1L);
    }

    public void testHistogramClass3() {
        Property property = ResourceFactory.createProperty("http://example.org#phone");
        Histogram histogram = (Histogram)histograms.get(property);
        TestIndex.assertEquals(histogram.getClassFrequency(Node.createLiteral("xxx-xxx-xxx")), 5L);
    }

    public void testHistogramClass4() {
        Property property = ResourceFactory.createProperty("http://example.org#workplace");
        Histogram histogram = (Histogram)histograms.get(property);
        TestIndex.assertEquals(histogram.getClassFrequency(Node.createLiteral("company1")), 2L);
        TestIndex.assertEquals(histogram.getClassFrequency(Node.createLiteral("company3")), 1L);
        TestIndex.assertEquals(histogram.getClassFrequency(Node.createLiteral("company10")), 0L);
    }

    public void testNumOfIndexedPatterns() {
        TestIndex.assertEquals(patterns.size(), properties.size() * properties.size() * 4);
    }

    public void testPattern1() {
        Property joiningP = ResourceFactory.createProperty("http://example.org#phone");
        Property joinedP = ResourceFactory.createProperty("http://example.org#phone");
        Resource joinT = ResourceFactory.createResource("http://jena.hpl.hp.com/ARQo/join#OO");
        Pattern pattern = new Pattern(joiningP, joinedP, joinT);
        TestIndex.assertEquals((Long)patterns.get(pattern), 25L);
    }

    public void testPattern2() {
        Property joiningP = ResourceFactory.createProperty("http://example.org#email");
        Property joinedP = ResourceFactory.createProperty("http://example.org#skype");
        Resource joinT = ResourceFactory.createResource("http://jena.hpl.hp.com/ARQo/join#SS");
        Pattern pattern = new Pattern(joiningP, joinedP, joinT);
        TestIndex.assertEquals((Long)patterns.get(pattern), 4L);
    }

    public void testPattern3() {
        Property joiningP = ResourceFactory.createProperty("http://example.org#skype");
        Property joinedP = ResourceFactory.createProperty("http://example.org#skype");
        Resource joinT = ResourceFactory.createResource("http://jena.hpl.hp.com/ARQo/join#SS");
        Pattern pattern = new Pattern(joiningP, joinedP, joinT);
        TestIndex.assertEquals((Long)patterns.get(pattern), 6L);
    }

    public void testPattern4() {
        Property joiningP = ResourceFactory.createProperty("http://example.org#firstname");
        Property joinedP = ResourceFactory.createProperty("http://example.org#skype");
        Resource joinT = ResourceFactory.createResource("http://jena.hpl.hp.com/ARQo/join#SO");
        Pattern pattern = new Pattern(joiningP, joinedP, joinT);
        TestIndex.assertEquals((Long)patterns.get(pattern), 0L);
    }

    public void testPattern5() {
        Property joiningP = ResourceFactory.createProperty("http://example.org#workplace");
        Property joinedP = ResourceFactory.createProperty("http://example.org#workplace");
        Resource joinT = ResourceFactory.createResource("http://jena.hpl.hp.com/ARQo/join#OO");
        Pattern pattern = new Pattern(joiningP, joinedP, joinT);
        TestIndex.assertEquals((Long)patterns.get(pattern), 9L);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite("TestIndex");
        ts.addTest(new TestIndex("testDataGraphSize"));
        ts.addTest(new TestIndex("testIndexedSize"));
        ts.addTest(new TestIndex("testMinProbability"));
        ts.addTest(new TestIndex("testMinJoinedProbability"));
        ts.addTest(new TestIndex("testSquaredDataGraphSize"));
        ts.addTest(new TestIndex("testSquaredIndexedSize"));
        ts.addTest(new TestIndex("testIndexAllowsJoinedProbability"));
        ts.addTest(new TestIndex("testIndexLevel"));
        ts.addTest(new TestIndex("testNumOfIndexedResources"));
        ts.addTest(new TestIndex("testIndexedSSSize"));
        ts.addTest(new TestIndex("testIndexedSOSize"));
        ts.addTest(new TestIndex("testIndexedOSSize"));
        ts.addTest(new TestIndex("testIndexedOOSize"));
        ts.addTest(new TestIndex("testNumOfIndexedProperties"));
        ts.addTest(new TestIndex("testPropertyLookup1"));
        ts.addTest(new TestIndex("testPropertyLookup2"));
        ts.addTest(new TestIndex("testPropertyLookup3"));
        ts.addTest(new TestIndex("testPropertyLookup4"));
        ts.addTest(new TestIndex("testPropertyLookup5"));
        ts.addTest(new TestIndex("testNumOfIndexedHistograms"));
        ts.addTest(new TestIndex("testHistogram1"));
        ts.addTest(new TestIndex("testHistogram2"));
        ts.addTest(new TestIndex("testHistogram3"));
        ts.addTest(new TestIndex("testHistogram4"));
        ts.addTest(new TestIndex("testHistogramClass1"));
        ts.addTest(new TestIndex("testHistogramClass2"));
        ts.addTest(new TestIndex("testHistogramClass3"));
        ts.addTest(new TestIndex("testHistogramClass4"));
        ts.addTest(new TestIndex("testNumOfIndexedPatterns"));
        ts.addTest(new TestIndex("testPattern1"));
        ts.addTest(new TestIndex("testPattern2"));
        ts.addTest(new TestIndex("testPattern3"));
        ts.addTest(new TestIndex("testPattern4"));
        ts.addTest(new TestIndex("testPattern5"));
        TestSetup wrapper = new TestSetup(ts){

            protected void setUp() {
                TestIndex.oneTimeSetUp();
            }

            protected void tearDown() {
                TestIndex.oneTimeTearDown();
            }
        };
        return wrapper;
    }
}

