/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.vocabulary.XSD;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSSE_Forms
extends TestCase {
    static PrefixMapping pmap = new PrefixMappingImpl();

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestSSE_Forms.class);
        ts.setName("SSE Resolve");
        SSE.getDefaultPrefixMapRead().removeNsPrefix("");
        SSE.getDefaultPrefixMapRead().removeNsPrefix("ex");
        return ts;
    }

    public void testBase_01() {
        Item r = Item.createNode(Node.createURI("http://example/x"));
        this.testItem("(base <http://example/> <x>)", r);
    }

    public void testBase_02() {
        Item r = Item.createNode(Node.createURI("http://example/x"));
        this.testItem("(base <http://HOST/> (base <http://example/xyz> <x>))", r);
    }

    public void testBase_03() {
        Item r = SSE.parse("(1 <http://example/xyz>)", null);
        this.testItem("(base <http://example/> (1 <xyz>))", r);
    }

    public void testBase_04() {
        Item r = SSE.parse("(1 <http://example/xyz>)", null);
        this.testItem("(1 (base <http://example/> <xyz>))", r);
    }

    public void testBase_05() {
        Item r = SSE.parse("(<http://example/xyz> <http://EXAMPLE/other#foo>)", null);
        this.testItem("((base <http://example/> <xyz>) (base <http://EXAMPLE/other> <#foo>))", r);
    }

    public void testBase_06() {
        Item r = SSE.parse("(<http://example/xyz> <http://EXAMPLE/other#foo>)", null);
        this.testItem("(base <http://example/> (<xyz> (base <http://EXAMPLE/other> <#foo>)))", r);
    }

    public void testBase_07() {
        Item r = SSE.parse("(<http://example/xyz> <http://EXAMPLE/other#foo>)", null);
        this.testItem("(base <http://EXAMPLE/other#> ((base <http://example/> <xyz>) <#foo>))", r);
    }

    public void testPrefix_01() {
        Item r = Item.createNode(Node.createURI("http://example/abc"));
        this.testItem("(prefix ((ex: <http://example/>)) ex:abc)", r);
    }

    public void testPrefix_02() {
        Item r = Item.createNode(Node.createURI("http://EXAMPLE/abc"));
        this.testItem("(prefix ((ex: <http://example/>)) (prefix ((ex: <http://EXAMPLE/>)) ex:abc))", r);
    }

    public void testPrefix_03() {
        Item r = SSE.parse("(<http://example/abc>)", null);
        this.testItem("(prefix ((ex: <http://example/>)) (ex:abc))", r);
    }

    public void testPrefix_04() {
        Item r = SSE.parse("(<http://EXAMPLE/abc>)", null);
        this.testItem("(prefix ((ex: <http://example/>)) ( (prefix ((ex: <http://EXAMPLE/>)) ex:abc) ))", r);
    }

    public void testPrefix_05() {
        Item r = SSE.parse("(<http://example/abc>)", null);
        this.testItem("(prefix ((ex: <http://example/>)) ( (prefix ((x: <http://EXAMPLE/>)) ex:abc) ))", r);
    }

    public void testForm_01() {
        Item item = SSE.parse("(prefix ((ex: <http://example/>)))");
        TestSSE_Forms.assertNull(item);
    }

    public void testForm_02() {
        Item item = SSE.parse("(base <http://example/>)");
        TestSSE_Forms.assertNull(item);
    }

    public void testTypedLit_r1() {
        Node node = Node.createLiteral("3", null, XSDDatatype.XSDinteger);
        this.testItem("'3'^^xsd:integer", Item.createNode(node));
    }

    public void testBasePrefix_01() {
        Item r = SSE.parse("<http://example/abc>", null);
        this.testItem("(base <http://example/> (prefix ((x: <>)) x:abc) )", r);
    }

    private void testItem(String str2, Item result) {
        Item item = SSE.parse(str2);
        TestSSE_Forms.assertEquals(result, item);
    }

    static {
        pmap.setNsPrefix("xsd", XSD.getURI());
        pmap.setNsPrefix("ex", "http://example/");
    }
}

