/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.lang;

import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.builders.BuilderPrefixMapping;
import com.hp.hpl.jena.sparql.sse.lang.ParseHandlerForm;
import com.hp.hpl.jena.sparql.util.StringUtils;
import java.util.Iterator;
import java.util.Stack;

public class ParseHandlerResolver
extends ParseHandlerForm {
    private static final String prefixTag = "prefix";
    private static final String baseTag = "base";
    private PrefixMapping topMap = null;
    private String topBase = null;
    private Prologue prologue = null;
    private ItemList declList = null;
    private Stack state = new Stack();

    public ParseHandlerResolver(Prologue p) {
        this.prologue = p;
    }

    protected void declItem(ItemList list, Item item) {
        if (list != this.declList) {
            return;
        }
        boolean isBase = list.get(0).isSymbol(baseTag);
        boolean isPrefix = list.get(0).isSymbol(prefixTag);
        if (isBase) {
            if (!item.isNode()) {
                ParseHandlerResolver.throwException("(base ...): not an RDF node for the base.", item);
            }
            if (!item.getNode().isURI()) {
                ParseHandlerResolver.throwException("(base ...): not an IRI for the base.", item);
            }
            String baseIRI = item.getNode().getURI();
            this.prologue = this.prologue.sub(baseIRI);
            if (this.topBase == null) {
                this.topBase = baseIRI;
            }
            return;
        }
        if (isPrefix) {
            PrefixMapping newMappings = BuilderPrefixMapping.build(item);
            this.prologue = this.prologue.sub(newMappings);
            if (this.topMap == null) {
                this.topMap = newMappings;
            }
            return;
        }
        ParseHandlerResolver.throwException("Inconsistent: " + list.shortString(), list);
    }

    protected boolean endOfDecl(ItemList list, Item item) {
        if (this.declList == list && list.size() == 2) {
            this.declList = null;
            return true;
        }
        return false;
    }

    protected boolean isForm(Item tag) {
        return tag.isSymbol(baseTag) || tag.isSymbol(prefixTag);
    }

    protected void startForm(ItemList list) {
        this.declList = list;
        this.state.push(this.prologue);
    }

    private void dump() {
        Iterator iter = this.state.iterator();
        while (iter.hasNext()) {
            Prologue p = (Prologue)iter.next();
            System.out.println("  Prologue: " + p.getBaseURI());
        }
    }

    protected void finishForm(ItemList list) {
        this.prologue = (Prologue)this.state.pop();
        if (list.size() > 2) {
            Item item = list.getLast();
            super.setFormResult(item);
        }
    }

    public void emitIRI(int line, int column, String iriStr) {
        iriStr = this.resolveIRI(iriStr, line, column);
        super.emitIRI(line, column, iriStr);
    }

    public void emitPName(int line, int column, String pname) {
        if (this.inFormDecl()) {
            Item item = Item.createSymbol(pname, line, column);
            this.listAdd(item);
            return;
        }
        String iriStr = this.resolvePrefixedName(pname, line, column);
        super.emitIRI(line, column, iriStr);
    }

    protected String resolvePrefixedName(String pname, int line, int column) {
        String uri;
        if (this.prologue.getPrefixMapping() == null) {
            ParseHandlerResolver.throwException("No prefix mapping for prefixed name: " + pname, line, column);
        }
        if (!StringUtils.contains(pname, ":")) {
            ParseHandlerResolver.throwException("Prefixed name does not have a ':': " + pname, line, column);
        }
        if ((uri = this.prologue.getPrefixMapping().expandPrefix(pname)) == null || uri.equals(pname)) {
            ParseHandlerResolver.throwException("Can't resolve prefixed name: " + pname, line, column);
        }
        return uri;
    }

    private String resolveIRI(String iriStr, int line, int column) {
        if (this.prologue.getResolver() != null) {
            return this.prologue.getResolver().resolve(iriStr);
        }
        return iriStr;
    }
}

