/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.WrappedGraph;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import java.util.ArrayList;
import junit.framework.TestSuite;

public class TestRemoveSPO
extends ModelTestBase {
    public TestRemoveSPO(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestRemoveSPO.class);
    }

    public void testRemoveSPOReturnsModel() {
        ModelCom m = new ModelCom(Factory.createDefaultGraph());
        TestRemoveSPO.assertSame(m, m.remove(TestRemoveSPO.resource("R"), TestRemoveSPO.property("P"), TestRemoveSPO.rdfNode(m, "17")));
    }

    public void testRemoveSPOCallsGraphDeleteTriple() {
        Graph base = Factory.createDefaultGraph();
        final ArrayList deleted = new ArrayList();
        WrappedGraph wrapped = new WrappedGraph(base){

            public void delete(Triple t) {
                deleted.add(t);
            }
        };
        ModelCom m = new ModelCom(wrapped);
        m.remove(TestRemoveSPO.resource("R"), TestRemoveSPO.property("P"), TestRemoveSPO.rdfNode(m, "17"));
        TestRemoveSPO.assertEquals(TestRemoveSPO.listOfOne(Triple.create("R P 17")), deleted);
    }
}

