/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatchFilter;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MixedGraphMemStore {
    protected final Graph parent;
    protected Map map = CollectionFactory.createHashedMap();
    protected int size = 0;

    public MixedGraphMemStore(Graph parent) {
        this.parent = parent;
    }

    protected boolean add(Node key, Triple t) {
        Set s = (Set)this.map.get(key);
        if (s == null) {
            s = CollectionFactory.createHashedSet();
            this.map.put(key, s);
        }
        return s.add(t);
    }

    protected boolean remove(Node key, Triple t) {
        Set s = (Set)this.map.get(key);
        if (s != null) {
            boolean removed = s.remove(t);
            if (s.isEmpty()) {
                this.map.put(key, null);
            }
            return removed;
        }
        return false;
    }

    public void add(Triple t) {
        if (this.add(t.getSubject(), t)) {
            ++this.size;
            this.add(t.getPredicate(), t);
            this.add(t.getObject(), t);
        }
    }

    public void remove(Triple t) {
        if (this.remove(t.getSubject(), t)) {
            --this.size;
            this.remove(t.getPredicate(), t);
            this.remove(t.getObject(), t);
        }
    }

    public boolean contains(Triple t) {
        Set s = (Set)this.map.get(t.getSubject());
        return s != null && s.contains(t);
    }

    public ExtendedIterator iterator(final Node key, Triple pattern) {
        Set s = (Set)this.map.get(key);
        if (s == null) {
            return NullIterator.instance;
        }
        final Iterator it = s.iterator();
        return new NiceIterator(){
            private Triple remember = null;

            public Object next() {
                this.remember = (Triple)it.next();
                return this.remember;
            }

            public boolean hasNext() {
                return it.hasNext();
            }

            public void excise(Node k, Triple triple) {
                if (k != key) {
                    MixedGraphMemStore.this.remove(k, triple);
                }
            }

            public void remove() {
                it.remove();
                --MixedGraphMemStore.this.size;
                this.excise(this.remember.getSubject(), this.remember);
                this.excise(this.remember.getPredicate(), this.remember);
                this.excise(this.remember.getObject(), this.remember);
                MixedGraphMemStore.this.parent.getEventManager().notifyDeleteTriple(MixedGraphMemStore.this.parent, this.remember);
            }
        }.filterKeep(new TripleMatchFilter(pattern));
    }

    public ExtendedIterator iterator(final Triple pattern) {
        return new NiceIterator(){
            protected Iterator keys;
            protected Iterator current;
            protected Triple triple;
            protected Triple remember;
            protected Node key;
            protected Set seen;
            {
                this.keys = MixedGraphMemStore.this.map.keySet().iterator();
                this.current = NullIterator.instance;
                this.triple = null;
                this.remember = null;
                this.key = null;
                this.seen = CollectionFactory.createHashedSet();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object next() {
                this.ensureHasNext();
                try {
                    Triple triple = this.remember = this.triple;
                    return triple;
                }
                finally {
                    this.triple = null;
                }
            }

            public boolean hasNext() {
                if (this.triple == null) {
                    while (this.current.hasNext()) {
                        this.triple = (Triple)this.current.next();
                        if (!pattern.matches(this.triple) || this.seen.contains(this.triple)) {
                            this.triple = null;
                            continue;
                        }
                        this.seen.add(this.triple);
                        return true;
                    }
                    if (this.keys.hasNext()) {
                        this.key = (Node)this.keys.next();
                        Set s = (Set)MixedGraphMemStore.this.map.get(this.key);
                        if (s == null) {
                            return this.hasNext();
                        }
                        this.current = s.iterator();
                        return this.hasNext();
                    }
                    return false;
                }
                return true;
            }

            public void excise(Node key, Triple triple) {
                if (key != this.key) {
                    MixedGraphMemStore.this.remove(key, triple);
                }
            }

            public void remove() {
                this.current.remove();
                --MixedGraphMemStore.this.size;
                this.excise(this.remember.getSubject(), this.remember);
                this.excise(this.remember.getPredicate(), this.remember);
                this.excise(this.remember.getObject(), this.remember);
                MixedGraphMemStore.this.parent.getEventManager().notifyDeleteTriple(MixedGraphMemStore.this.parent, this.remember);
            }
        };
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.map.clear();
        this.size = 0;
    }
}

