/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.InfModelAssembler;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OntModelAssembler
extends InfModelAssembler
implements Assembler {
    private static final OntModelSpec defaultSpec = OntModelSpec.OWL_MEM_RDFS_INF;

    public Model openEmptyModel(Assembler a, Resource root, Mode mode) {
        this.checkType(root, JA.OntModel);
        Model baseModel = this.getBase(a, root, mode);
        OntModelSpec oms = this.getOntModelSpec(a, root);
        OntModel om = ModelFactory.createOntologyModel(oms, baseModel);
        this.addSubModels(a, root, mode, om);
        return om;
    }

    private void addSubModels(Assembler a, Resource root, Mode mode, OntModel om) {
        List subModels = this.getSubModels(a, root, mode);
        Iterator it = subModels.iterator();
        while (it.hasNext()) {
            om.addSubModel((Model)it.next());
        }
    }

    private List getSubModels(Assembler a, Resource root, Mode mode) {
        ArrayList<Model> result = new ArrayList<Model>();
        StmtIterator it = root.listProperties(JA.subModel);
        while (it.hasNext()) {
            result.add(a.openModel(it.nextStatement().getResource(), mode));
        }
        return result;
    }

    protected OntModelSpec getOntModelSpec(Assembler a, Resource root) {
        Resource r = OntModelAssembler.getUniqueResource(root, JA.ontModelSpec);
        return r == null ? defaultSpec : (OntModelSpec)a.open(r);
    }
}

