/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.logging;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggerFactory;
import com.hazelcast.logging.NoLogFactory;
import com.hazelcast.logging.StandardLoggerFactory;
import com.hazelcast.nio.Serializer;

public class Logger {
    private static volatile LoggerFactory loggerFactory = null;
    private static final Object factoryLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ILogger getLogger(String name) {
        if (loggerFactory == null) {
            Object object = factoryLock;
            synchronized (object) {
                if (loggerFactory == null) {
                    String loggerType = System.getProperty("hazelcast.logging.type");
                    loggerFactory = Logger.newLoggerFactory(loggerType);
                }
            }
        }
        return loggerFactory.getLogger(name);
    }

    public static LoggerFactory newLoggerFactory(String loggerType) {
        LoggerFactory loggerFactory = null;
        String loggerClass = System.getProperty("hazelcast.logging.class");
        if (loggerClass != null) {
            try {
                loggerFactory = (LoggerFactory)Serializer.loadClass(loggerClass).newInstance();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        if (loggerFactory == null && loggerType != null) {
            if ("log4j".equals(loggerType)) {
                try {
                    loggerFactory = (LoggerFactory)Serializer.loadClass("com.hazelcast.logging.Log4jFactory").newInstance();
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            } else if ("slf4j".equals(loggerType)) {
                try {
                    loggerFactory = (LoggerFactory)Serializer.loadClass("com.hazelcast.logging.Slf4jFactory").newInstance();
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
            } else if ("jdk".equals(loggerType)) {
                loggerFactory = new StandardLoggerFactory();
            } else if ("none".equals(loggerType)) {
                loggerFactory = new NoLogFactory();
            }
        }
        if (loggerFactory == null) {
            loggerFactory = new StandardLoggerFactory();
        }
        return loggerFactory;
    }
}

