/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.jmx.JMXAttribute;
import com.hazelcast.jmx.JMXDescription;
import com.hazelcast.jmx.JMXOperation;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.jmx.ObjectNameSpec;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMBean<E>
implements DynamicMBean,
MBeanRegistration {
    protected static final Logger logger = Logger.getLogger(AbstractMBean.class.getName());
    protected transient MBeanServer mbeanServer;
    private volatile ObjectNameSpec parentName = new ObjectNameSpec();
    private volatile ObjectName objectName;
    private E managedObject;
    private String description;
    protected final ManagementService managementService;
    private HashMap<String, AttributeInfo> attributeInfos = new HashMap();
    private HashMap<String, OperationInfo> operationInfos = new HashMap();

    public AbstractMBean(E managedObject, ManagementService service) {
        this.managedObject = managedObject;
        this.managementService = service;
    }

    public final E getManagedObject() {
        return this.managedObject;
    }

    protected E refresh() {
        return this.getManagedObject();
    }

    private final void instrument() throws Exception {
        JMXDescription dscr = this.getClass().getAnnotation(JMXDescription.class);
        if (dscr != null) {
            this.description = dscr.value();
        }
        for (Method method : this.getClass().getMethods()) {
            Object info;
            String name;
            Annotation annotation;
            if (method.isAnnotationPresent(JMXAttribute.class)) {
                annotation = method.getAnnotation(JMXAttribute.class);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Found annotation " + annotation + " in method " + method.getName() + " in object " + this.hashCode() + " of class " + this.getClass().getName());
                }
                if ((name = annotation.value()).length() == 0) {
                    String methodName = method.getName();
                    if (methodName.startsWith("get")) {
                        name = methodName.substring(3);
                    } else if (methodName.startsWith("set")) {
                        name = methodName.substring(3);
                    } else if (methodName.startsWith("is")) {
                        name = methodName.substring(2);
                    } else {
                        logger.warning("Uncomplaint method name " + method.getName() + " for attribute");
                        name = method.getName();
                    }
                }
                if ((info = this.attributeInfos.get(name)) == null) {
                    info = new AttributeInfo(name);
                    this.attributeInfos.put(name, (AttributeInfo)info);
                }
                if ((dscr = method.getAnnotation(JMXDescription.class)) != null) {
                    if (((AttributeInfo)info).description != null) {
                        logger.warning("Duplicate description for attribute " + name + ", overwrite");
                    }
                    ((AttributeInfo)info).description = dscr.value();
                }
                if (method.getReturnType() != Void.class && method.getParameterTypes().length == 0) {
                    if (((AttributeInfo)info).getter != null) {
                        throw new IllegalArgumentException("Duplicate getter for attribute " + name + " in class " + this.getClass().getName());
                    }
                    ((AttributeInfo)info).getter = method;
                } else if (method.getReturnType() == Void.class && method.getParameterTypes().length == 1) {
                    if (((AttributeInfo)info).setter != null) {
                        throw new IllegalArgumentException("Duplicate setter for attribute " + name + " in class " + this.getClass().getName());
                    }
                    ((AttributeInfo)info).setter = method;
                } else {
                    logger.warning("Method " + method.getName() + " is neither a setter or a getter");
                }
            }
            if (!method.isAnnotationPresent(JMXOperation.class)) continue;
            annotation = method.getAnnotation(JMXOperation.class);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Found operation annotation " + annotation);
            }
            if ((name = annotation.value()).length() == 0) {
                throw new IllegalArgumentException("Empty operation name in  " + method.getName() + " in class " + this.getClass().getName());
            }
            if (this.operationInfos.containsKey(name)) {
                throw new IllegalArgumentException("Duplicate operation " + name + " in class " + this.getClass().getName());
            }
            info = new OperationInfo(name);
            this.operationInfos.put(name, (OperationInfo)info);
            dscr = method.getAnnotation(JMXDescription.class);
            if (dscr != null) {
                ((OperationInfo)info).description = dscr.value();
            }
            ((OperationInfo)info).method = method;
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbeanInfo = new MBeanInfo(this.managedObject.getClass().getName(), this.description, this.buildAttributeInfos(), null, this.buildOperationInfos(), null);
        return mbeanInfo;
    }

    private Object getValue(String attribute, boolean refresh) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object result;
        if (attribute == null || attribute.length() == 0) {
            throw new NullPointerException("Invalid null attribute requested");
        }
        AttributeInfo info = this.attributeInfos.get(attribute);
        if (info == null) {
            logger.log(Level.WARNING, "Managed attribute " + attribute + " not registered in MBean");
            throw new AttributeNotFoundException("Attribute " + attribute + " not registered in MBean");
        }
        if (refresh) {
            this.managedObject = this.refresh();
        }
        try {
            Method getter = info.getter;
            if (getter.getDeclaringClass() == this.getClass()) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Attribute '" + attribute + "' belonging to MBean");
                }
                result = getter.invoke((Object)this, new Object[0]);
            } else {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Attribute '" + attribute + "' belonging to managed object");
                }
                result = getter.invoke(this.managedObject, new Object[0]);
            }
        }
        catch (Exception e2) {
            logger.log(Level.FINE, "Error accessing attribute " + attribute, e2);
            throw new ReflectionException(e2);
        }
        return result;
    }

    @Override
    public final Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.getValue(attribute, true);
    }

    @Override
    public final AttributeList getAttributes(String[] attributes) {
        this.managedObject = this.refresh();
        AttributeList result = new AttributeList(attributes.length);
        try {
            for (String name : attributes) {
                Object value = this.getValue(name, false);
                Attribute attribute = new Attribute(name, value);
                result.add(attribute);
            }
        }
        catch (Exception e2) {
            throw new IllegalArgumentException(e2);
        }
        return result;
    }

    @Override
    public final Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Object result;
        if (actionName == null || actionName.length() == 0) {
            throw new NullPointerException("Invalid null operation invoked");
        }
        OperationInfo info = this.operationInfos.get(actionName);
        if (info == null) {
            logger.log(Level.WARNING, "Managed operation " + actionName + " not registered in MBean");
            throw new UnsupportedOperationException("Operation " + actionName + " not registered in MBean");
        }
        try {
            Method method = info.method;
            if (method.getDeclaringClass() == this.getClass()) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Operation '" + actionName + "' belonging to MBean");
                }
                result = method.invoke((Object)this, params);
            } else {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Operation '" + actionName + "' belonging to managed object", actionName);
                }
                result = method.invoke(this.managedObject, params);
            }
        }
        catch (Exception e2) {
            logger.log(Level.FINE, "Error invoking operation " + actionName, e2);
            throw new ReflectionException(e2);
        }
        return result;
    }

    @Override
    public final void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException();
    }

    private MBeanAttributeInfo[] buildAttributeInfos() {
        if (this.attributeInfos == null || this.attributeInfos.size() == 0) {
            return null;
        }
        MBeanAttributeInfo[] result = new MBeanAttributeInfo[this.attributeInfos.size()];
        int i = 0;
        for (AttributeInfo info : this.attributeInfos.values()) {
            try {
                result[i++] = info.getInfo();
            }
            catch (IntrospectionException e2) {
                logger.log(Level.WARNING, "Error building attribute list", e2);
                throw new IllegalArgumentException(e2);
            }
        }
        return result;
    }

    private MBeanOperationInfo[] buildOperationInfos() {
        if (this.operationInfos == null || this.operationInfos.size() == 0) {
            return null;
        }
        MBeanOperationInfo[] result = new MBeanOperationInfo[this.operationInfos.size()];
        int i = 0;
        for (OperationInfo info : this.operationInfos.values()) {
            try {
                result[i++] = info.getInfo();
            }
            catch (IntrospectionException e2) {
                logger.log(Level.WARNING, "Error building operation list", e2);
                throw new IllegalArgumentException(e2);
            }
        }
        return result;
    }

    public void setParentName(ObjectNameSpec spec) {
        this.parentName = spec;
    }

    public ObjectNameSpec getParentName() {
        return this.parentName;
    }

    protected ObjectNameSpec getNameSpec() {
        return this.parentName.getNested("unknown", "@" + this.hashCode());
    }

    public final ObjectName getObjectName() throws Exception {
        if (this.objectName == null) {
            this.objectName = this.getNameSpec().buildObjectName();
        }
        return this.objectName;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        try {
            this.instrument();
        }
        catch (Exception e2) {
            logger.log(Level.FINE, "Error generating MBeanInfo", e2);
            throw e2;
        }
        if (name != null) {
            this.objectName = name;
        }
        this.mbeanServer = server;
        return this.getObjectName();
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    private class OperationInfo {
        protected transient String name;
        protected transient String description;
        protected transient Method method;
        protected MBeanOperationInfo info;

        public OperationInfo(String name) {
            this.name = name;
        }

        public OperationInfo(String description, Method method) throws IntrospectionException {
            this.info = new MBeanOperationInfo(description, method);
            this.method = method;
        }

        public MBeanOperationInfo getInfo() throws IntrospectionException {
            if (this.info == null) {
                this.info = new MBeanOperationInfo(this.description, this.method);
            }
            return this.info;
        }
    }

    private class AttributeInfo {
        protected String name;
        protected String description = null;
        protected Method getter = null;
        protected Method setter = null;

        public AttributeInfo(String name) {
            this.name = name;
        }

        public MBeanAttributeInfo getInfo() throws IntrospectionException {
            return new MBeanAttributeInfo(this.name, this.description, this.getter, this.setter);
        }
    }
}

