/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StringUtils {
    private static final String FOLDER_SEPARATOR = "/";
    private static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    private static final String TOP_PATH = "..";
    private static final String CURRENT_PATH = ".";
    private static final char EXTENSION_SEPARATOR = '.';

    public static boolean hasLength(CharSequence str2) {
        return str2 != null && str2.length() > 0;
    }

    public static boolean hasLength(String str2) {
        return StringUtils.hasLength((CharSequence)str2);
    }

    public static boolean hasText(CharSequence str2) {
        if (!StringUtils.hasLength(str2)) {
            return false;
        }
        int strLen = str2.length();
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(str2.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasText(String str2) {
        return StringUtils.hasText((CharSequence)str2);
    }

    public static boolean containsWhitespace(CharSequence str2) {
        if (!StringUtils.hasLength(str2)) {
            return false;
        }
        int strLen = str2.length();
        int i = 0;
        while (i < strLen) {
            if (Character.isWhitespace(str2.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsWhitespace(String str2) {
        return StringUtils.containsWhitespace((CharSequence)str2);
    }

    public static String trimWhitespace(String str2) {
        if (!StringUtils.hasLength(str2)) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String trimAllWhitespace(String str2) {
        if (!StringUtils.hasLength(str2)) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2);
        int index = 0;
        while (sb.length() > index) {
            if (Character.isWhitespace(sb.charAt(index))) {
                sb.deleteCharAt(index);
                continue;
            }
            ++index;
        }
        return sb.toString();
    }

    public static String trimLeadingWhitespace(String str2) {
        if (!StringUtils.hasLength(str2)) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimTrailingWhitespace(String str2) {
        if (!StringUtils.hasLength(str2)) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String trimLeadingCharacter(String str2, char leadingCharacter) {
        if (!StringUtils.hasLength(str2)) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2);
        while (sb.length() > 0 && sb.charAt(0) == leadingCharacter) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimTrailingCharacter(String str2, char trailingCharacter) {
        if (!StringUtils.hasLength(str2)) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2);
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == trailingCharacter) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean startsWithIgnoreCase(String str2, String prefix) {
        if (str2 == null || prefix == null) {
            return false;
        }
        if (str2.startsWith(prefix)) {
            return true;
        }
        if (str2.length() < prefix.length()) {
            return false;
        }
        String lcStr = str2.substring(0, prefix.length()).toLowerCase();
        String lcPrefix = prefix.toLowerCase();
        return lcStr.equals(lcPrefix);
    }

    public static boolean endsWithIgnoreCase(String str2, String suffix) {
        if (str2 == null || suffix == null) {
            return false;
        }
        if (str2.endsWith(suffix)) {
            return true;
        }
        if (str2.length() < suffix.length()) {
            return false;
        }
        String lcStr = str2.substring(str2.length() - suffix.length()).toLowerCase();
        String lcSuffix = suffix.toLowerCase();
        return lcStr.equals(lcSuffix);
    }

    public static boolean substringMatch(CharSequence str2, int index, CharSequence substring2) {
        int j = 0;
        while (j < substring2.length()) {
            int i = index + j;
            if (i >= str2.length() || str2.charAt(i) != substring2.charAt(j)) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public static int countOccurrencesOf(String str2, String sub) {
        int idx;
        if (str2 == null || sub == null || str2.length() == 0 || sub.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((idx = str2.indexOf(sub, pos)) != -1) {
            ++count;
            pos = idx + sub.length();
        }
        return count;
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (!StringUtils.hasLength(inString) || !StringUtils.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString.substring(pos, index));
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static String delete(String inString, String pattern) {
        return StringUtils.replace(inString, pattern, "");
    }

    public static String deleteAny(String inString, String charsToDelete) {
        if (!StringUtils.hasLength(inString) || !StringUtils.hasLength(charsToDelete)) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < inString.length()) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) == -1) {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String quote(String str2) {
        return str2 != null ? "'" + str2 + "'" : null;
    }

    public static Object quoteIfString(Object obj) {
        return obj instanceof String ? StringUtils.quote((String)obj) : obj;
    }

    public static String unqualify(String qualifiedName) {
        return StringUtils.unqualify(qualifiedName, '.');
    }

    public static String unqualify(String qualifiedName, char separator) {
        return qualifiedName.substring(qualifiedName.lastIndexOf(separator) + 1);
    }

    public static String capitalize(String str2) {
        return StringUtils.changeFirstCharacterCase(str2, true);
    }

    public static String uncapitalize(String str2) {
        return StringUtils.changeFirstCharacterCase(str2, false);
    }

    private static String changeFirstCharacterCase(String str2, boolean capitalize) {
        if (str2 == null || str2.length() == 0) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2.length());
        if (capitalize) {
            sb.append(Character.toUpperCase(str2.charAt(0)));
        } else {
            sb.append(Character.toLowerCase(str2.charAt(0)));
        }
        sb.append(str2.substring(1));
        return sb.toString();
    }

    public static String getFilename(String path) {
        if (path == null) {
            return null;
        }
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        return separatorIndex != -1 ? path.substring(separatorIndex + 1) : path;
    }

    public static String getFilenameExtension(String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(46);
        if (extIndex == -1) {
            return null;
        }
        int folderIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (folderIndex > extIndex) {
            return null;
        }
        return path.substring(extIndex + 1);
    }

    public static String stripFilenameExtension(String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(46);
        if (extIndex == -1) {
            return path;
        }
        int folderIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (folderIndex > extIndex) {
            return path;
        }
        return path.substring(0, extIndex);
    }

    public static String applyRelativePath(String path, String relativePath) {
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (separatorIndex != -1) {
            String newPath = path.substring(0, separatorIndex);
            if (!relativePath.startsWith(FOLDER_SEPARATOR)) {
                newPath = String.valueOf(newPath) + FOLDER_SEPARATOR;
            }
            return String.valueOf(newPath) + relativePath;
        }
        return relativePath;
    }

    public static String cleanPath(String path) {
        if (path == null) {
            return null;
        }
        String pathToUse = StringUtils.replace(path, WINDOWS_FOLDER_SEPARATOR, FOLDER_SEPARATOR);
        int prefixIndex = pathToUse.indexOf(":");
        String prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            pathToUse = pathToUse.substring(prefixIndex + 1);
        }
        if (pathToUse.startsWith(FOLDER_SEPARATOR)) {
            prefix = String.valueOf(prefix) + FOLDER_SEPARATOR;
            pathToUse = pathToUse.substring(1);
        }
        String[] pathArray = StringUtils.delimitedListToStringArray(pathToUse, FOLDER_SEPARATOR);
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        int i = pathArray.length - 1;
        while (i >= 0) {
            String element = pathArray[i];
            if (!CURRENT_PATH.equals(element)) {
                if (TOP_PATH.equals(element)) {
                    ++tops;
                } else if (tops > 0) {
                    --tops;
                } else {
                    pathElements.add(0, element);
                }
            }
            --i;
        }
        i = 0;
        while (i < tops) {
            pathElements.add(0, TOP_PATH);
            ++i;
        }
        return String.valueOf(prefix) + StringUtils.collectionToDelimitedString(pathElements, FOLDER_SEPARATOR);
    }

    public static boolean pathEquals(String path1, String path2) {
        return StringUtils.cleanPath(path1).equals(StringUtils.cleanPath(path2));
    }

    public static Locale parseLocaleString(String localeString) {
        int endIndexOfCountryCode;
        String[] parts = StringUtils.tokenizeToStringArray(localeString, "_ ", false, false);
        String language = parts.length > 0 ? parts[0] : "";
        String country = parts.length > 1 ? parts[1] : "";
        StringUtils.validateLocalePart(language);
        StringUtils.validateLocalePart(country);
        String variant = "";
        if (parts.length >= 2 && (variant = StringUtils.trimLeadingWhitespace(localeString.substring(endIndexOfCountryCode = localeString.indexOf(country) + country.length()))).startsWith("_")) {
            variant = StringUtils.trimLeadingCharacter(variant, '_');
        }
        return language.length() > 0 ? new Locale(language, country, variant) : null;
    }

    private static void validateLocalePart(String localePart) {
        int i = 0;
        while (i < localePart.length()) {
            char ch = localePart.charAt(i);
            if (ch != '_' && ch != ' ' && !Character.isLetterOrDigit(ch)) {
                throw new IllegalArgumentException("Locale part \"" + localePart + "\" contains invalid characters");
            }
            ++i;
        }
    }

    public static String toLanguageTag(Locale locale) {
        return String.valueOf(locale.getLanguage()) + (StringUtils.hasText(locale.getCountry()) ? "-" + locale.getCountry() : "");
    }

    public static String[] addStringToArray(String[] array, String str2) {
        if (ObjectUtils.isEmpty(array)) {
            return new String[]{str2};
        }
        String[] newArr = new String[array.length + 1];
        System.arraycopy(array, 0, newArr, 0, array.length);
        newArr[array.length] = str2;
        return newArr;
    }

    public static String[] concatenateStringArrays(String[] array1, String[] array2) {
        if (ObjectUtils.isEmpty(array1)) {
            return array2;
        }
        if (ObjectUtils.isEmpty(array2)) {
            return array1;
        }
        String[] newArr = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, newArr, 0, array1.length);
        System.arraycopy(array2, 0, newArr, array1.length, array2.length);
        return newArr;
    }

    public static String[] mergeStringArrays(String[] array1, String[] array2) {
        if (ObjectUtils.isEmpty(array1)) {
            return array2;
        }
        if (ObjectUtils.isEmpty(array2)) {
            return array1;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll((Collection)Arrays.asList(array1));
        String[] stringArray = array2;
        int n = array2.length;
        int n2 = 0;
        while (n2 < n) {
            String str2 = stringArray[n2];
            if (!result.contains(str2)) {
                result.add(str2);
            }
            ++n2;
        }
        return StringUtils.toStringArray(result);
    }

    public static String[] sortStringArray(String[] array) {
        if (ObjectUtils.isEmpty(array)) {
            return new String[0];
        }
        Arrays.sort(array);
        return array;
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static String[] toStringArray(Enumeration<String> enumeration) {
        if (enumeration == null) {
            return null;
        }
        List list = Collections.list(enumeration);
        return list.toArray(new String[list.size()]);
    }

    public static String[] trimArrayElements(String[] array) {
        if (ObjectUtils.isEmpty(array)) {
            return new String[0];
        }
        String[] result = new String[array.length];
        int i = 0;
        while (i < array.length) {
            String element = array[i];
            result[i] = element != null ? element.trim() : null;
            ++i;
        }
        return result;
    }

    public static String[] removeDuplicateStrings(String[] array) {
        if (ObjectUtils.isEmpty(array)) {
            return array;
        }
        TreeSet<String> set = new TreeSet<String>();
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            set.add(element);
            ++n2;
        }
        return StringUtils.toStringArray(set);
    }

    public static String[] split(String toSplit, String delimiter) {
        if (!StringUtils.hasLength(toSplit) || !StringUtils.hasLength(delimiter)) {
            return null;
        }
        int offset = toSplit.indexOf(delimiter);
        if (offset < 0) {
            return null;
        }
        String beforeDelimiter = toSplit.substring(0, offset);
        String afterDelimiter = toSplit.substring(offset + delimiter.length());
        return new String[]{beforeDelimiter, afterDelimiter};
    }

    public static Properties splitArrayElementsIntoProperties(String[] array, String delimiter) {
        return StringUtils.splitArrayElementsIntoProperties(array, delimiter, null);
    }

    public static Properties splitArrayElementsIntoProperties(String[] array, String delimiter, String charsToDelete) {
        if (ObjectUtils.isEmpty(array)) {
            return null;
        }
        Properties result = new Properties();
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String[] splittedElement;
            String element = stringArray[n2];
            if (charsToDelete != null) {
                element = StringUtils.deleteAny(element, charsToDelete);
            }
            if ((splittedElement = StringUtils.split(element, delimiter)) != null) {
                result.setProperty(splittedElement[0].trim(), splittedElement[1].trim());
            }
            ++n2;
        }
        return result;
    }

    public static String[] tokenizeToStringArray(String str2, String delimiters) {
        return StringUtils.tokenizeToStringArray(str2, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(String str2, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str2 == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str2, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return StringUtils.toStringArray(tokens);
    }

    public static String[] delimitedListToStringArray(String str2, String delimiter) {
        return StringUtils.delimitedListToStringArray(str2, delimiter, null);
    }

    public static String[] delimitedListToStringArray(String str2, String delimiter, String charsToDelete) {
        if (str2 == null) {
            return new String[0];
        }
        if (delimiter == null) {
            return new String[]{str2};
        }
        ArrayList<String> result = new ArrayList<String>();
        if ("".equals(delimiter)) {
            int i = 0;
            while (i < str2.length()) {
                result.add(StringUtils.deleteAny(str2.substring(i, i + 1), charsToDelete));
                ++i;
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str2.indexOf(delimiter, pos)) != -1) {
                result.add(StringUtils.deleteAny(str2.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str2.length() > 0 && pos <= str2.length()) {
                result.add(StringUtils.deleteAny(str2.substring(pos), charsToDelete));
            }
        }
        return StringUtils.toStringArray(result);
    }

    public static String[] commaDelimitedListToStringArray(String str2) {
        return StringUtils.delimitedListToStringArray(str2, ",");
    }

    public static Set<String> commaDelimitedListToSet(String str2) {
        String[] tokens;
        TreeSet<String> set = new TreeSet<String>();
        String[] stringArray = tokens = StringUtils.commaDelimitedListToStringArray(str2);
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            set.add(token);
            ++n2;
        }
        return set;
    }

    public static String collectionToDelimitedString(Collection<?> coll, String delim, String prefix, String suffix) {
        if (CollectionUtils.isEmpty(coll)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String collectionToDelimitedString(Collection<?> coll, String delim) {
        return StringUtils.collectionToDelimitedString(coll, delim, "", "");
    }

    public static String collectionToCommaDelimitedString(Collection<?> coll) {
        return StringUtils.collectionToDelimitedString(coll, ",");
    }

    public static String arrayToDelimitedString(Object[] arr, String delim) {
        if (ObjectUtils.isEmpty(arr)) {
            return "";
        }
        if (arr.length == 1) {
            return ObjectUtils.nullSafeToString(arr[0]);
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < arr.length) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(arr[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String arrayToCommaDelimitedString(Object[] arr) {
        return StringUtils.arrayToDelimitedString(arr, ",");
    }
}

