/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.persistence.EntityNotFoundException;
import org.hibernate.HibernateException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.QueryCache;
import org.hibernate.cache.QueryKey;
import org.hibernate.cache.QueryResultsRegion;
import org.hibernate.cache.UpdateTimestampsCache;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardQueryCache
implements QueryCache {
    private static final Logger log = LoggerFactory.getLogger(StandardQueryCache.class);
    private QueryResultsRegion cacheRegion;
    private UpdateTimestampsCache updateTimestampsCache;

    public void clear() throws CacheException {
        this.cacheRegion.evictAll();
    }

    public StandardQueryCache(Settings settings, Properties props, UpdateTimestampsCache updateTimestampsCache, String regionName) throws HibernateException {
        String prefix;
        if (regionName == null) {
            regionName = StandardQueryCache.class.getName();
        }
        if ((prefix = settings.getCacheRegionPrefix()) != null) {
            regionName = prefix + '.' + regionName;
        }
        log.info("starting query cache at region: " + regionName);
        this.cacheRegion = settings.getRegionFactory().buildQueryResultsRegion(regionName, props);
        this.updateTimestampsCache = updateTimestampsCache;
    }

    public boolean put(QueryKey key, Type[] returnTypes, List result, boolean isNaturalKeyLookup, SessionImplementor session) throws HibernateException {
        if (isNaturalKeyLookup && result.size() == 0) {
            return false;
        }
        Long ts = new Long(session.getFactory().getSettings().getRegionFactory().nextTimestamp());
        if (log.isDebugEnabled()) {
            log.debug("caching query results in region: " + this.cacheRegion.getName() + "; timestamp=" + ts);
        }
        ArrayList<Object> cacheable = new ArrayList<Object>(result.size() + 1);
        cacheable.add(ts);
        for (Object aResult : result) {
            if (returnTypes.length == 1) {
                cacheable.add(returnTypes[0].disassemble(aResult, session, null));
                continue;
            }
            cacheable.add(TypeHelper.disassemble((Object[])aResult, returnTypes, null, session, null));
        }
        this.cacheRegion.put(key, cacheable);
        return true;
    }

    public List get(QueryKey key, Type[] returnTypes, boolean isNaturalKeyLookup, Set spaces, SessionImplementor session) throws HibernateException {
        List cacheable;
        if (log.isDebugEnabled()) {
            log.debug("checking cached query results in region: " + this.cacheRegion.getName());
        }
        if ((cacheable = (List)this.cacheRegion.get(key)) == null) {
            log.debug("query results were not found in cache");
            return null;
        }
        Long timestamp = (Long)cacheable.get(0);
        if (!isNaturalKeyLookup && !this.isUpToDate(spaces, timestamp)) {
            log.debug("cached query results were not up to date");
            return null;
        }
        log.debug("returning cached query results");
        for (int i = 1; i < cacheable.size(); ++i) {
            if (returnTypes.length == 1) {
                returnTypes[0].beforeAssemble((Serializable)cacheable.get(i), session);
                continue;
            }
            TypeHelper.beforeAssemble((Serializable[])cacheable.get(i), returnTypes, session);
        }
        ArrayList<Object> result = new ArrayList<Object>(cacheable.size() - 1);
        for (int i = 1; i < cacheable.size(); ++i) {
            try {
                if (returnTypes.length == 1) {
                    result.add(returnTypes[0].assemble((Serializable)cacheable.get(i), session, null));
                    continue;
                }
                result.add(TypeHelper.assemble((Serializable[])cacheable.get(i), returnTypes, session, null));
                continue;
            }
            catch (RuntimeException ex) {
                if (isNaturalKeyLookup && (UnresolvableObjectException.class.isInstance(ex) || EntityNotFoundException.class.isInstance(ex))) {
                    log.debug("could not reassemble cached result set");
                    this.cacheRegion.evict(key);
                    return null;
                }
                throw ex;
            }
        }
        return result;
    }

    protected boolean isUpToDate(Set spaces, Long timestamp) {
        if (log.isDebugEnabled()) {
            log.debug("Checking query spaces for up-to-dateness: " + spaces);
        }
        return this.updateTimestampsCache.isUpToDate(spaces, timestamp);
    }

    public void destroy() {
        try {
            this.cacheRegion.destroy();
        }
        catch (Exception e2) {
            log.warn("could not destroy query cache: " + this.cacheRegion.getName(), e2);
        }
    }

    public QueryResultsRegion getRegion() {
        return this.cacheRegion;
    }

    public String toString() {
        return "StandardQueryCache(" + this.cacheRegion.getName() + ')';
    }
}

