/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication.auditor.v1.controller;

import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import org.dataone.cn.dao.exceptions.DataAccessException;
import org.dataone.service.cn.replication.auditor.v1.controller.AbstractReplicationAuditor;
import org.dataone.service.cn.replication.auditor.v1.task.CoordinatingNodeReplicaAuditTask;
import org.dataone.service.types.v1.Identifier;

public class ManualCoordinatingNodeReplicaAuditor
extends AbstractReplicationAuditor {
    private static final int pageSize = 200;
    private static final int pidsPerTaskSize = 20;
    private static final int taskPoolSize = 10;
    private static final int maxPages = 100000;
    private static final long executionWaitSeconds = 60L;
    private static final String MANUAL_AUDIT_LOCK_NAME = "manualCoordinatingNodeReplicationAuditLock";
    private Date auditDate = null;

    public ManualCoordinatingNodeReplicaAuditor(Date auditDate) {
        this.auditDate = auditDate;
    }

    @Override
    protected String getLockName() {
        return MANUAL_AUDIT_LOCK_NAME;
    }

    @Override
    protected Date calculateAuditDate() {
        return this.auditDate;
    }

    @Override
    protected List<Identifier> getPidsToAudit(Date auditDate, int pageNumber, int pageSize) throws DataAccessException {
        return this.replicationDao.getCompletedCoordinatingNodeReplicasByDate(auditDate, pageNumber, pageSize);
    }

    @Override
    protected Callable<String> newAuditTask(List<Identifier> pids, Date auditDate) {
        return new CoordinatingNodeReplicaAuditTask(pids, auditDate);
    }

    @Override
    protected boolean tryLock(Lock lock) {
        return true;
    }

    @Override
    protected void releaseLock(Lock lock) {
    }

    @Override
    protected Lock getProcessingLock() {
        return null;
    }

    @Override
    protected int getMaxPages() {
        return 100000;
    }

    @Override
    protected int getTaskPoolSize() {
        return 10;
    }

    @Override
    protected int getPageSize() {
        return 200;
    }

    @Override
    protected int getPidsPerTaskSize() {
        return 20;
    }

    @Override
    protected boolean shouldRunAudit() {
        return true;
    }

    @Override
    protected long getFutureExecutionWaitTimeSeconds() {
        return 60L;
    }
}

