/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.dataone.client.D1NodeFactory;
import org.dataone.client.auth.CertificateManager;
import org.dataone.client.rest.DefaultHttpMultipartRestClient;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.cn.dao.DaoFactory;
import org.dataone.cn.dao.exceptions.DataAccessException;
import org.dataone.cn.data.repository.ReplicationAttemptHistory;
import org.dataone.cn.data.repository.ReplicationAttemptHistoryRepository;
import org.dataone.cn.data.repository.ReplicationTask;
import org.dataone.cn.data.repository.ReplicationTaskRepository;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.configuration.Settings;
import org.dataone.service.cn.replication.ApiVersion;
import org.dataone.service.cn.replication.QueuedReplicationAuditor;
import org.dataone.service.cn.replication.ReplicationFactory;
import org.dataone.service.cn.replication.ReplicationPrioritizationStrategy;
import org.dataone.service.cn.replication.ReplicationRepositoryFactory;
import org.dataone.service.cn.replication.ReplicationService;
import org.dataone.service.cn.replication.ReplicationStatusMonitor;
import org.dataone.service.cn.replication.ReplicationTaskMonitor;
import org.dataone.service.cn.replication.ReplicationTaskProcessor;
import org.dataone.service.cn.replication.ReplicationTaskQueue;
import org.dataone.service.cn.replication.StaleReplicationRequestAuditor;
import org.dataone.service.cn.v2.CNReplication;
import org.dataone.service.cn.v2.NodeRegistryService;
import org.dataone.service.cn.v2.impl.NodeRegistryServiceImpl;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.VersionMismatch;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.NodeReplicationPolicy;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.ReplicationStatus;
import org.dataone.service.types.v1.Service;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.SystemMetadata;

public class ReplicationManager {
    public static Logger log = Logger.getLogger(ReplicationManager.class);
    private ReplicationService replicationService;
    private HazelcastClient hzClient;
    private HazelcastClient hzProcessingClient;
    private NodeRegistryService nodeService = new NodeRegistryServiceImpl();
    private IMap<Identifier, SystemMetadata> systemMetadataMap;
    private ReplicationTaskQueue replicationTaskQueue;
    private String nodeReplicationStatusMapName;
    private IMap<String, Integer> nodeReplicationStatusMap;
    private CNReplication cnReplication = null;
    private ReplicationPrioritizationStrategy prioritizationStrategy = new ReplicationPrioritizationStrategy();
    private static ScheduledExecutorService staleRequestedReplicaAuditScheduler;
    private static ScheduledExecutorService staleQueuedReplicaAuditScheduler;
    private static ScheduledExecutorService replicationTaskProcessingScheduler;
    private static ScheduledExecutorService replicationTaskMonitoringScheduler;
    private static ScheduledExecutorService replicationStatusMonitoringScheduler;
    private ReplicationAttemptHistoryRepository replicationAttemptHistoryRepository;
    private ReplicationTaskRepository taskRepository;
    private static final Integer DEFAULT_NUMBER_OF_REPLICAS;
    private static final Integer REPLICATION_ATTEMPTS_PER_DAY;
    private long replicationTaskMonitorFreq;
    private long replicationStatusMonitorFreq;

    public ReplicationManager() {
        this(null);
    }

    public ReplicationManager(ReplicationRepositoryFactory repositoryFactory) {
        this.nodeReplicationStatusMapName = Settings.getConfiguration().getString("dataone.hazelcast.nodeReplicationStatusMap");
        this.replicationTaskMonitorFreq = Settings.getConfiguration().getLong("replication.task.monitoring.freq.minutes", 3L);
        this.replicationStatusMonitorFreq = Settings.getConfiguration().getLong("replication.status.monitoring.freq.minutes", 10L);
        this.hzClient = HazelcastClientFactory.getStorageClient();
        this.hzProcessingClient = HazelcastClientFactory.getProcessingClient();
        this.systemMetadataMap = HazelcastClientFactory.getSystemMetadataMap();
        this.nodeReplicationStatusMap = this.hzProcessingClient.getMap(this.nodeReplicationStatusMapName);
        this.replicationTaskQueue = ReplicationFactory.getReplicationTaskQueue();
        this.replicationService = ReplicationFactory.getReplicationService();
        if (repositoryFactory != null) {
            this.taskRepository = repositoryFactory.getReplicationTaskRepository();
            this.replicationAttemptHistoryRepository = repositoryFactory.getReplicationTryHistoryRepository();
        } else {
            this.replicationAttemptHistoryRepository = ReplicationFactory.getReplicationTryHistoryRepository();
            this.taskRepository = ReplicationFactory.getReplicationTaskRepository();
        }
        this.startStaleRequestedAuditing();
        this.startStaleQueuedAuditing();
        this.startReplicationTaskProcessing();
        this.startReplicationMonitoring();
        this.startReplicationStatusMonitoring();
        String clientCertificateLocation = Settings.getConfiguration().getString("D1Client.certificate.directory") + File.separator + Settings.getConfiguration().getString("D1Client.certificate.filename");
        CertificateManager.getInstance().setCertificateLocation(clientCertificateLocation);
        log.info("ReplicationManager is using an X509 certificate from " + clientCertificateLocation);
        this.init();
    }

    private void init() {
        log.info("initialization");
        CNode cnode = null;
        String settingsBaseUrl = Settings.getConfiguration().getString("D1Client.CN_URL");
        log.debug("D1Client.CN_URL = " + settingsBaseUrl);
        try {
            cnode = D1Client.getCN();
            log.info("ReplicationManager D1Client base_url is: " + cnode.getNodeBaseServiceUrl());
        }
        catch (BaseException e2) {
            try {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    log.error("There was a problem getting a Coordinating Node reference.", e1);
                }
                cnode = D1Client.getCN();
            }
            catch (BaseException e1) {
                log.warn("Building CNode without baseURL check.");
                try {
                    cnode = D1NodeFactory.buildNode(CNode.class, new DefaultHttpMultipartRestClient(), URI.create(settingsBaseUrl));
                }
                catch (Exception e22) {
                    log.error("There was a problem getting a Coordinating Node reference  for the ReplicationManager. ", e22);
                    throw new RuntimeException(e22);
                }
            }
        }
        this.cnReplication = cnode;
    }

    public Node getNode(NodeReference nodeRef) {
        Node node = null;
        try {
            node = this.nodeService.getNodeCapabilities(nodeRef);
        }
        catch (ServiceFailure e2) {
            log.error("Unable to locate node from node service for node ref: " + nodeRef.getValue(), e2);
            e2.printStackTrace();
        }
        catch (NotFound e3) {
            log.error("Unable to locate node from node service for node ref: " + nodeRef.getValue(), e3);
            e3.printStackTrace();
        }
        return node;
    }

    public Set<NodeReference> getNodeReferences() {
        HashSet<NodeReference> nodeRefs = new HashSet<NodeReference>();
        try {
            for (Node node : this.nodeService.listNodes().getNodeList()) {
                NodeReference nodeRef = new NodeReference();
                nodeRef.setValue(node.getIdentifier().getValue());
                nodeRefs.add(nodeRef);
            }
        }
        catch (NotImplemented ni) {
            log.error("Unable to get node list from node registry service", ni);
            ni.printStackTrace();
        }
        catch (ServiceFailure sf) {
            log.error("Unable to get node list from node registry service", sf);
            sf.printStackTrace();
        }
        return nodeRefs;
    }

    protected List<String> getObjectVersion(SystemMetadata sysmeta) {
        LinkedList<String> versions = new LinkedList<String>();
        Node n = this.getNode(sysmeta.getAuthoritativeMemberNode());
        if (n != null && n.getServices() != null && n.getServices().getServiceList() != null) {
            for (Service s : n.getServices().getServiceList()) {
                if (!s.getName().equals("MNReplication")) continue;
                versions.add(s.getVersion());
            }
        }
        return versions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createAndQueueTasks(Identifier pid) {
        log.debug("ReplicationManager.createAndQueueTasks called.");
        int taskCount = 0;
        long timeToWait = 5L;
        String lockPid = pid.getValue();
        ILock lock = this.hzProcessingClient.getLock(lockPid);
        boolean isLocked = false;
        try {
            isLocked = lock.tryLock(timeToWait, TimeUnit.MILLISECONDS);
            if (isLocked) {
                taskCount = this.processPid(pid);
            } else {
                log.info("Couldn't get a lock while evaluating identifier " + pid.getValue() + ". Assuming another CN handled it.");
            }
        }
        catch (InterruptedException ie) {
            this.requeueReplicationTask(pid);
            log.info("The lock was interrupted while evaluating identifier " + pid.getValue() + ". Re-queuing the identifer.");
        }
        catch (Exception e2) {
            this.requeueReplicationTask(pid);
            log.error("Unhandled Exception for pid: " + pid.getValue() + ". Error is : " + e2.getMessage(), e2);
        }
        finally {
            if (isLocked) {
                lock.unlock();
            }
        }
        log.info("Added " + taskCount + " MNReplicationTasks to the queue for " + pid.getValue());
        if (taskCount == 0) {
            this.requeueReplicationTask(pid);
        }
        return taskCount;
    }

    private int processPid(Identifier pid) throws InvalidRequest, ServiceFailure, NotFound {
        SystemMetadata sysmeta = this.systemMetadataMap.get(pid);
        if (sysmeta == null) {
            throw new NotFound("-100", "Could not retreive sysmeta from map for pid " + pid.getValue());
        }
        boolean allowed = this.isAllowed(sysmeta);
        if (!allowed) {
            log.debug("Replication is not allowed for the object identified by " + pid.getValue());
            this.removeReplicationTasksForPid(pid);
            return 0;
        }
        log.debug("Replication is allowed for identifier " + pid.getValue());
        int taskCount = 0;
        log.debug("Getting the replica list for identifier " + pid.getValue());
        int desiredReplicas = DEFAULT_NUMBER_OF_REPLICAS;
        try {
            desiredReplicas = sysmeta.getReplicationPolicy().getNumberReplicas();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        List<NodeReference> existingQualifiedReplicas = this.calcQualifiedReplicas(sysmeta);
        int neededReplicas = desiredReplicas - existingQualifiedReplicas.size();
        log.debug("Needed replicas " + neededReplicas);
        if (neededReplicas <= 0) {
            log.debug("Have enough replicas already");
            this.removeReplicationTasksForPid(pid);
            return 0;
        }
        log.debug("Building a potential target node list for identifier " + pid.getValue());
        Node authoritativeNode = this.nodeService.getNodeCapabilities(sysmeta.getAuthoritativeMemberNode());
        ApiVersion sourceReplicationSupport = this.getSupportedReplicationVersion(pid, authoritativeNode);
        List<Object> potentialTargetNodes = new ArrayList();
        if (sourceReplicationSupport != null) {
            Set<NodeReference> nodeList = this.getNodeReferences();
            potentialTargetNodes = this.getPotentialTargetNodes(nodeList, sysmeta, sourceReplicationSupport);
            potentialTargetNodes.removeAll(existingQualifiedReplicas);
            log.trace("METRICS:\tPRIORITIZE:\tPID:\t" + pid.getValue());
            potentialTargetNodes = this.prioritizeNodes(neededReplicas, potentialTargetNodes, sysmeta);
            log.trace("METRICS:\tEND PRIORITIZE:\tPID:\t" + pid.getValue());
        }
        this.reportCountsByNodeStatus();
        if (!potentialTargetNodes.isEmpty()) {
            log.info("Number of replicas desired for identifier " + pid.getValue() + " is " + neededReplicas);
            log.info("Potential target node list size for " + pid.getValue() + " is " + potentialTargetNodes.size());
            if (neededReplicas > potentialTargetNodes.size()) {
                neededReplicas = potentialTargetNodes.size();
                log.info("Changed the desired replicas for identifier " + pid.getValue() + " to the size of the potential target node list: " + potentialTargetNodes.size());
            }
            taskCount = this.createAndQueueTasks(pid, potentialTargetNodes, neededReplicas);
        }
        return taskCount;
    }

    protected ApiVersion getSupportedReplicationVersion(Identifier pid, Node authoritativeNode) throws InvalidRequest {
        ApiVersion sourceReplicationSupport = null;
        try {
            if (authoritativeNode != null && authoritativeNode.getServices() != null && authoritativeNode.getServices().getServiceList() != null) {
                List<Service> nodeServices = authoritativeNode.getServices().getServiceList();
                for (Service service : nodeServices) {
                    if (!service.getName().equals("MNRead") || !service.getAvailable().booleanValue()) continue;
                    log.info("for pid: " + pid.getValue() + " source MN: " + authoritativeNode.getIdentifier().getValue() + " service info: " + service.getName() + " " + service.getVersion());
                    if (sourceReplicationSupport == null) {
                        sourceReplicationSupport = ApiVersion.getVersion(service.getVersion());
                        continue;
                    }
                    if (sourceReplicationSupport.compareTo(ApiVersion.getVersion(service.getVersion())) >= 0) continue;
                    sourceReplicationSupport = ApiVersion.getVersion(service.getVersion());
                }
            }
        }
        catch (NullPointerException npe) {
            throw new InvalidRequest("1080", "Object " + pid.getValue() + " has no authoritative Member Node in its SystemMetadata");
        }
        log.info(String.format("for pid: %s, source MN: %s requires %s replication.", pid.getValue(), authoritativeNode.getIdentifier().getValue(), sourceReplicationSupport.getApiLabel()));
        return sourceReplicationSupport;
    }

    protected boolean targetNodeSupportsReplication(Node node, ApiVersion sourceVersion) {
        if (node != null && node.getType() == NodeType.MN && node.isReplicate() && node.getServices() != null && node.getServices().getServiceList() != null) {
            for (Service service : node.getServices().getServiceList()) {
                if (!service.getName().equals("MNReplication") || !service.getAvailable().booleanValue() || !ApiVersion.getVersion(service.getVersion()).equals(sourceVersion)) continue;
                return true;
            }
        }
        return false;
    }

    protected List<NodeReference> getPotentialTargetNodes(Set<NodeReference> nodeList, SystemMetadata smd, ApiVersion sourceReplicationSupport) throws ServiceFailure, NotFound {
        ArrayList<NodeReference> potentialTargetNodes = new ArrayList<NodeReference>();
        for (NodeReference nodeReference : nodeList) {
            Identifier pid = smd.getIdentifier();
            Node node = this.nodeService.getNodeCapabilities(nodeReference);
            if (nodeReference.equals(smd.getAuthoritativeMemberNode())) continue;
            if (this.isUnderReplicationAttemptsPerDay(pid, nodeReference)) {
                if (this.targetNodeSupportsReplication(node, sourceReplicationSupport) && this.passesReplicationPolicies(node, smd)) {
                    potentialTargetNodes.add(node.getIdentifier());
                    log.info(String.format("for pid: %s, target MN: %s supports %s MNReplication.", pid.getValue(), node.getIdentifier().getValue(), sourceReplicationSupport.getApiLabel()));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug(String.format("for pid: %s, target MN: %s does not share the latest api version with source node: %s", pid.getValue(), node.getIdentifier().getValue(), smd.getAuthoritativeMemberNode().getValue()));
                continue;
            }
            log.info(String.format("for pid: %s, target MN: %s is over the number of replication attempts for the day.", pid.getValue(), nodeReference.getValue()));
        }
        return potentialTargetNodes;
    }

    protected boolean passesReplicationPolicies(Node node, SystemMetadata sysmeta) {
        if (sysmeta.getReplicationPolicy() != null && sysmeta.getReplicationPolicy().getBlockedMemberNodeList() != null && sysmeta.getReplicationPolicy().getBlockedMemberNodeList().contains(node.getIdentifier())) {
            return false;
        }
        if (node.getNodeReplicationPolicy() == null) {
            return true;
        }
        NodeReplicationPolicy nrp = node.getNodeReplicationPolicy();
        if (nrp.getMaxObjectSize() != null && nrp.getMaxObjectSize().compareTo(sysmeta.getSize()) < 0) {
            return false;
        }
        List<ObjectFormatIdentifier> allowedFormats = nrp.getAllowedObjectFormatList();
        if (allowedFormats != null && !allowedFormats.contains(sysmeta.getFormatId())) {
            return false;
        }
        List<NodeReference> allowedNodes = nrp.getAllowedNodeList();
        return allowedNodes == null || allowedNodes.contains(sysmeta.getAuthoritativeMemberNode());
    }

    private int createAndQueueTasks(Identifier pid, List<NodeReference> prioritizedNodes, int desiredReplicas) throws ServiceFailure, NotFound {
        int taskCount = 0;
        Node targetNode = null;
        for (int j = 0; j < desiredReplicas; ++j) {
            boolean updated;
            block14: {
                log.debug("Evaluating item " + j + " of " + desiredReplicas + " in the potential node list.");
                NodeReference potentialNode = prioritizedNodes.get(j);
                targetNode = this.nodeService.getNodeCapabilities(potentialNode);
                log.debug("currently evaluating " + targetNode.getIdentifier().getValue() + " for task creation for identifier " + pid.getValue());
                updated = false;
                Replica replicaMetadata = new Replica();
                replicaMetadata.setReplicaMemberNode(targetNode.getIdentifier());
                replicaMetadata.setReplicationStatus(ReplicationStatus.QUEUED);
                replicaMetadata.setReplicaVerified(Calendar.getInstance().getTime());
                SystemMetadata sysmeta = null;
                try {
                    sysmeta = this.systemMetadataMap.get(pid);
                    updated = this.cnReplication.updateReplicationMetadata(null, pid, replicaMetadata, sysmeta.getSerialVersion().longValue());
                }
                catch (VersionMismatch e2) {
                    try {
                        sysmeta = this.systemMetadataMap.get(pid);
                        updated = this.cnReplication.updateReplicationMetadata(null, pid, replicaMetadata, sysmeta.getSerialVersion().longValue());
                    }
                    catch (VersionMismatch e1) {
                        String msg = "Couldn't get the correct serialVersion to update the replica metadata for identifier " + pid.getValue() + " and target node " + targetNode.getIdentifier().getValue();
                        log.error(msg);
                    }
                    catch (BaseException be) {
                        if (be instanceof InvalidRequest) {
                            log.warn("Couldn't update replication metadata to " + replicaMetadata.getReplicationStatus().toString() + ", it may have possibly already been updated for identifier " + pid.getValue() + " and target node " + replicaMetadata.getReplicaMemberNode().getValue() + ". The error was: " + be.getMessage(), be);
                            break block14;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug(be);
                        }
                        updated = this.replicationService.updateReplicationMetadata(pid, replicaMetadata);
                    }
                }
                catch (BaseException be) {
                    if (be instanceof InvalidRequest) {
                        log.warn("Couldn't update replication metadata to " + replicaMetadata.getReplicationStatus().toString() + ", it may have possibly already been updated for identifier " + pid.getValue() + " and target node " + replicaMetadata.getReplicaMemberNode().getValue() + ". The error was: " + be.getMessage(), be);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug(be);
                        }
                        updated = this.replicationService.updateReplicationMetadata(pid, replicaMetadata);
                    }
                }
                catch (RuntimeException re) {
                    log.error("Couldn't get system metadata for identifier " + pid.getValue() + " while trying to update replica metadata entry for node " + replicaMetadata.getReplicaMemberNode().getValue(), re);
                }
            }
            if (updated) {
                ++taskCount;
                this.requeueReplicationTask(pid);
                this.replicationTaskQueue.processAllTasksForMN(targetNode.getIdentifier().getValue());
                continue;
            }
            log.error("CN.updateReplicationMetadata() failed for identifier " + pid.getValue() + ", node " + targetNode.getIdentifier().getValue() + ". Task not created.");
        }
        return taskCount;
    }

    private void removeReplicationTasksForPid(Identifier pid) {
        if (pid != null) {
            log.info("removing replication tasks for pid: " + pid.getValue());
            List<ReplicationTask> tasks = this.taskRepository.findByPid(pid.getValue());
            this.taskRepository.delete(tasks);
        }
    }

    private void requeueReplicationTask(Identifier pid) {
        List<ReplicationTask> taskList = this.taskRepository.findByPid(pid.getValue());
        if (taskList.size() == 1) {
            ReplicationTask task = taskList.get(0);
            if ("IN PROCESS".equals(task.getStatus())) {
                task.markNew();
                this.taskRepository.save(task);
            }
        } else if (taskList.size() == 0) {
            log.warn("In Replication Manager, task that should exist 'in process' does not exist.  Creating new task for pid: " + pid.getValue());
            this.taskRepository.save(new ReplicationTask(pid));
        } else if (taskList.size() > 1) {
            log.warn("In Replication Manager, more than one task found for pid: " + pid.getValue() + ". Deleting all and creating new task.");
            this.taskRepository.delete(taskList);
            this.taskRepository.save(new ReplicationTask(pid));
        }
    }

    private boolean isAllowed(SystemMetadata sysmeta) {
        boolean isAllowed;
        String pidValue;
        block2: {
            pidValue = sysmeta.getIdentifier().getValue();
            log.debug("ReplicationManager.isAllowed() called for " + pidValue);
            isAllowed = false;
            try {
                isAllowed = sysmeta.getReplicationPolicy().getReplicationAllowed();
            }
            catch (RuntimeException e2) {
                isAllowed = false;
                if (!log.isDebugEnabled()) break block2;
                log.debug(String.format("%s caught in ReplicationManager.isAllowed() for identifier %s. The error message was: %s", e2.getClass().getName(), pidValue, e2.getMessage()));
            }
        }
        log.debug("ReplicationManager.isAllowed() = " + isAllowed + " for " + pidValue);
        return isAllowed;
    }

    private boolean isPending(Identifier pid) {
        SystemMetadata sysmeta = this.systemMetadataMap.get(pid);
        List<Replica> replicaList = sysmeta.getReplicaList();
        boolean is_pending = false;
        for (Replica replica : replicaList) {
            ReplicationStatus status = replica.getReplicationStatus();
            if (!status.equals(ReplicationStatus.QUEUED) && !status.equals(ReplicationStatus.REQUESTED)) continue;
            is_pending = true;
            break;
        }
        return is_pending;
    }

    public List<NodeReference> calcQualifiedReplicas(SystemMetadata sysmeta) {
        ArrayList<NodeReference> listedReplicaNodes = new ArrayList<NodeReference>();
        List<Replica> replicaList = sysmeta.getReplicaList();
        if (replicaList != null) {
            for (Replica listedReplica : replicaList) {
                ReplicationStatus listedStatus;
                NodeReference nodeId;
                block6: {
                    nodeId = listedReplica.getReplicaMemberNode();
                    listedStatus = listedReplica.getReplicationStatus();
                    try {
                        Node node = this.nodeService.getNodeCapabilities(nodeId);
                        if (node != null) {
                            log.debug("The potential replica node is: " + node.getIdentifier().getValue());
                            if (node.getType() == NodeType.CN || nodeId.equals(sysmeta.getAuthoritativeMemberNode())) {
                                continue;
                            }
                            break block6;
                        }
                        log.debug("The potential target node id is null for " + nodeId.getValue());
                        continue;
                    }
                    catch (Exception e2) {
                        log.debug("There was an error getting the node type: " + e2.getMessage(), e2);
                    }
                }
                if (listedStatus != ReplicationStatus.QUEUED && listedStatus != ReplicationStatus.REQUESTED && listedStatus != ReplicationStatus.COMPLETED && listedStatus != ReplicationStatus.INVALIDATED) continue;
                listedReplicaNodes.add(nodeId);
            }
        }
        return listedReplicaNodes;
    }

    public void setCnReplication(CNReplication cnReplication) {
        this.cnReplication = cnReplication;
    }

    private Map<NodeReference, Float> getPendingRequestFactors(List<NodeReference> nodeIdentifiers, boolean useCache) {
        return this.prioritizationStrategy.getPendingRequestFactors(nodeIdentifiers, useCache);
    }

    private Map<NodeReference, Float> getFailureFactors(List<NodeReference> nodeIdentifiers, boolean useCache) {
        return this.prioritizationStrategy.getFailureFactors(nodeIdentifiers, useCache);
    }

    private Map<NodeReference, Float> getBandwidthFactors(List<NodeReference> nodeIdentifiers, boolean useCache) {
        HashMap bandwidthFactors = new HashMap();
        return this.prioritizationStrategy.getBandwidthFactors(nodeIdentifiers, useCache);
    }

    private void reportCountsByNodeStatus() {
        Map<Object, Object> countsByNodeStatusMap;
        block2: {
            countsByNodeStatusMap = new HashMap();
            try {
                countsByNodeStatusMap = DaoFactory.getReplicationDao().getCountsByNodeStatus();
                log.debug("Counts by Node-Status map size: " + countsByNodeStatusMap.size());
            }
            catch (DataAccessException e2) {
                log.info("There was an error getting node-status counts: " + e2.getMessage());
                if (!log.isDebugEnabled()) break block2;
                e2.printStackTrace();
            }
        }
        this.nodeReplicationStatusMap.putAll(countsByNodeStatusMap);
    }

    private List<NodeReference> prioritizeNodes(int desiredReplicasLessListed, List<NodeReference> potentialNodeList, SystemMetadata sysmeta) {
        List<NodeReference> nodesByPriority = this.prioritizationStrategy.prioritizeNodes(potentialNodeList, sysmeta);
        Identifier pid = sysmeta.getIdentifier();
        log.debug("Nodes by priority list size: " + nodesByPriority.size());
        if (nodesByPriority.size() >= desiredReplicasLessListed) {
            log.debug("There are enough target nodes to fulfill the replication policy. Not resubmitting identifier " + pid.getValue());
        } else {
            log.debug("There are not enough target nodes to fulfill the replication policy. Resubmitting identifier " + pid.getValue());
            this.requeueReplicationTask(pid);
        }
        return nodesByPriority;
    }

    private void startStaleQueuedAuditing() {
        if (staleQueuedReplicaAuditScheduler == null || staleQueuedReplicaAuditScheduler.isShutdown()) {
            staleQueuedReplicaAuditScheduler = Executors.newSingleThreadScheduledExecutor();
            staleQueuedReplicaAuditScheduler.scheduleAtFixedRate(new QueuedReplicationAuditor(), 0L, 1L, TimeUnit.HOURS);
        }
    }

    private void startStaleRequestedAuditing() {
        if (staleRequestedReplicaAuditScheduler == null || staleRequestedReplicaAuditScheduler.isShutdown()) {
            staleRequestedReplicaAuditScheduler = Executors.newSingleThreadScheduledExecutor();
            staleRequestedReplicaAuditScheduler.scheduleAtFixedRate(new StaleReplicationRequestAuditor(), 0L, 1L, TimeUnit.HOURS);
        }
    }

    private void startReplicationTaskProcessing() {
        if (replicationTaskProcessingScheduler == null || replicationTaskProcessingScheduler.isShutdown()) {
            replicationTaskProcessingScheduler = Executors.newSingleThreadScheduledExecutor();
            replicationTaskProcessingScheduler.scheduleAtFixedRate(new ReplicationTaskProcessor(), 0L, 2L, TimeUnit.MINUTES);
        }
    }

    private void startReplicationMonitoring() {
        if (replicationTaskMonitoringScheduler == null || replicationTaskMonitoringScheduler.isShutdown()) {
            replicationTaskMonitoringScheduler = Executors.newSingleThreadScheduledExecutor();
            replicationTaskMonitoringScheduler.scheduleAtFixedRate(new ReplicationTaskMonitor(), 0L, this.replicationTaskMonitorFreq, TimeUnit.MINUTES);
        }
    }

    private void startReplicationStatusMonitoring() {
        if (replicationStatusMonitoringScheduler == null || replicationStatusMonitoringScheduler.isShutdown()) {
            replicationStatusMonitoringScheduler = Executors.newSingleThreadScheduledExecutor();
            replicationStatusMonitoringScheduler.scheduleAtFixedRate(new ReplicationStatusMonitor(), 1L, this.replicationStatusMonitorFreq, TimeUnit.MINUTES);
        }
    }

    private boolean isUnderReplicationAttemptsPerDay(Identifier identifier, NodeReference nodeReference) {
        if (identifier == null || identifier.getValue() == null || nodeReference == null || nodeReference.getValue() == null) {
            return false;
        }
        boolean underAttemptsPerDay = false;
        ReplicationAttemptHistory attemptHistory = this.findReplicationAttemptHistoryRecord(identifier, nodeReference);
        if (attemptHistory == null) {
            attemptHistory = new ReplicationAttemptHistory(identifier, nodeReference, 1);
            attemptHistory = this.replicationAttemptHistoryRepository.save(attemptHistory);
            underAttemptsPerDay = true;
        } else if (attemptHistory != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(10, -24);
            if (attemptHistory.getLastReplicationAttemptDate() < calendar.getTimeInMillis()) {
                attemptHistory.setReplicationAttempts(1);
                attemptHistory.setLastReplicationAttemptDate(System.currentTimeMillis());
                attemptHistory = this.replicationAttemptHistoryRepository.save(attemptHistory);
                underAttemptsPerDay = true;
            } else if (attemptHistory.getLastReplicationAttemptDate() >= calendar.getTimeInMillis()) {
                if (attemptHistory.getReplicationAttempts() < REPLICATION_ATTEMPTS_PER_DAY) {
                    attemptHistory.incrementReplicationAttempts();
                    attemptHistory.setLastReplicationAttemptDate(System.currentTimeMillis());
                    attemptHistory = this.replicationAttemptHistoryRepository.save(attemptHistory);
                    underAttemptsPerDay = true;
                } else if (attemptHistory.getReplicationAttempts() >= REPLICATION_ATTEMPTS_PER_DAY) {
                    underAttemptsPerDay = false;
                }
            }
        }
        return underAttemptsPerDay;
    }

    private ReplicationAttemptHistory findReplicationAttemptHistoryRecord(Identifier identifier, NodeReference nodeReference) {
        List<ReplicationAttemptHistory> attemptHistoryList = this.replicationAttemptHistoryRepository.findByPidAndNodeId(identifier.getValue(), nodeReference.getValue());
        ReplicationAttemptHistory attemptHistory = null;
        if (attemptHistoryList.size() > 1) {
            log.error("More than one replication attempt history exists for pid: " + identifier.getValue() + " and node: " + nodeReference.getValue() + ".  Using first result, deleting others.");
            for (ReplicationAttemptHistory attemptHistoryResult : attemptHistoryList) {
                if (attemptHistory == null) {
                    attemptHistory = attemptHistoryResult;
                    continue;
                }
                this.replicationAttemptHistoryRepository.delete(attemptHistoryResult);
            }
        } else if (attemptHistoryList.size() == 1) {
            attemptHistory = attemptHistoryList.get(0);
        }
        return attemptHistory;
    }

    static {
        DEFAULT_NUMBER_OF_REPLICAS = 3;
        REPLICATION_ATTEMPTS_PER_DAY = 10;
    }
}

