/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.ProfileRegistry;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.vocabulary.OntDocManagerVocab;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestOntDocumentManager
extends TestCase {
    private static Boolean F = Boolean.FALSE;
    private static Boolean T = Boolean.TRUE;
    private static Log log = LogFactory.getLog(TestOntDocumentManager.class);
    public static Object[][] s_testData = new Object[][]{{"testing/ontology/testImport1", TestOntDocumentManager.cnt(1), T, null}, {"testing/ontology/testImport2", TestOntDocumentManager.cnt(2), T, null}, {"testing/ontology/testImport2", TestOntDocumentManager.cnt(1), F, null}, {"testing/ontology/testImport3", TestOntDocumentManager.cnt(3), T, null}, {"testing/ontology/testImport4", TestOntDocumentManager.cnt(2), T, null}, {"testing/ontology/testImport5", TestOntDocumentManager.cnt(2), T, "file:testing/ontology/testImport5/ont-policy.rdf"}};

    public static final Integer cnt(int x) {
        return new Integer(x);
    }

    public TestOntDocumentManager(String s) {
        super(s);
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite("TestOntDocumentManager");
        suite.addTestSuite(TestOntDocumentManager.class);
        for (int i = 0; i < s_testData.length; ++i) {
            suite.addTest(new DocManagerImportTest((String)s_testData[i][0], (Integer)s_testData[i][1], (Boolean)s_testData[i][2], (String)s_testData[i][3]));
        }
        return suite;
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
        HashSet modelNames = new HashSet();
        ModelMaker memMaker = OntModelSpec.OWL_MEM.getImportModelMaker();
        Iterator i = memMaker.listModels();
        while (i.hasNext()) {
            modelNames.add(i.next());
        }
        i = modelNames.iterator();
        while (i.hasNext()) {
            String mn = (String)i.next();
            memMaker.removeModel(mn);
        }
    }

    public void testConstruct0() {
        OntDocumentManager m = new OntDocumentManager();
        TestOntDocumentManager.assertNotNull(m);
        TestOntDocumentManager.assertEquals(m.getMetadataSearchPath(), "file:ont-policy.rdf;file:etc/ont-policy.rdf");
    }

    public void testConstruct1() {
        OntDocumentManager mgr = new OntDocumentManager("");
        TestOntDocumentManager.assertTrue("Should be no specification loaded", !mgr.listDocuments().hasNext());
    }

    public void testConstruct2() {
        OntDocumentManager mgr = new OntDocumentManager((String)null);
        TestOntDocumentManager.assertTrue("Should be no specification loaded", !mgr.listDocuments().hasNext());
    }

    public void testConstruct3() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addProperty(RDF.type, OntDocManagerVocab.OntologySpec);
        r.addProperty(OntDocManagerVocab.publicURI, m.createResource("http://example.com/foo"));
        r.addProperty(OntDocManagerVocab.altURL, m.createResource("file:local.rdf"));
        OntDocumentManager mgr = new OntDocumentManager(m);
        TestOntDocumentManager.assertEquals("cache URL not correct", "file:local.rdf", mgr.doAltURLMapping("http://example.com/foo"));
    }

    public void testInitialisation() {
        OntDocumentManager mgr = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertTrue("Should be at least one specification loaded", mgr.listDocuments().hasNext());
        TestOntDocumentManager.assertNotNull("cache URL for owl should not be null", mgr.doAltURLMapping("http://www.w3.org/2002/07/owl"));
        TestOntDocumentManager.assertEquals("cache URL for owl not correct", "file:vocabularies/owl.owl", mgr.doAltURLMapping("http://www.w3.org/2002/07/owl"));
        TestOntDocumentManager.assertEquals("prefix for owl not correct", "owl", mgr.getPrefixForURI("http://www.w3.org/2002/07/owl#"));
    }

    public void testGetInstance() {
        OntDocumentManager odm = OntDocumentManager.getInstance();
        TestOntDocumentManager.assertNotNull(odm);
        OntDocumentManager odm2 = OntDocumentManager.getInstance();
        TestOntDocumentManager.assertSame(odm, odm2);
    }

    public void testSetMetadataSearchPath() {
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertEquals("file:etc/ont-policy-test.rdf", odm.getMetadataSearchPath());
        TestOntDocumentManager.assertTrue(odm.listDocuments().hasNext());
        TestOntDocumentManager.assertEquals("file:etc/ont-policy-test.rdf", odm.getLoadedPolicyURL());
        odm.setMetadataSearchPath("file:notexist.rdf", false);
        TestOntDocumentManager.assertTrue(odm.listDocuments().hasNext());
        TestOntDocumentManager.assertNull(odm.getLoadedPolicyURL());
        odm.setMetadataSearchPath("file:notexist.rdf", true);
        TestOntDocumentManager.assertFalse(odm.listDocuments().hasNext());
        TestOntDocumentManager.assertNull(odm.getLoadedPolicyURL());
        odm.setMetadataSearchPath("file:etc/ont-policy-test.rdf", false);
        TestOntDocumentManager.assertTrue(odm.listDocuments().hasNext());
        TestOntDocumentManager.assertEquals("file:etc/ont-policy-test.rdf", odm.getLoadedPolicyURL());
    }

    public void testConfigure0() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addProperty(RDF.type, OntDocManagerVocab.OntologySpec);
        r.addProperty(OntDocManagerVocab.publicURI, m.createResource("http://example.com/foo"));
        r.addProperty(OntDocManagerVocab.altURL, m.createResource("file:local.rdf"));
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestUtil.assertIteratorLength(odm.listDocuments(), 3);
        odm.configure(m, false);
        TestUtil.assertIteratorLength(odm.listDocuments(), 4);
    }

    public void testConfigure1() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addProperty(RDF.type, OntDocManagerVocab.OntologySpec);
        r.addProperty(OntDocManagerVocab.publicURI, m.createResource("http://example.com/foo"));
        r.addProperty(OntDocManagerVocab.altURL, m.createResource("file:local.rdf"));
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestUtil.assertIteratorLength(odm.listDocuments(), 3);
        odm.configure(m);
        TestUtil.assertIteratorLength(odm.listDocuments(), 1);
    }

    public void testConfigure2() {
        Model m = ModelFactory.createDefaultModel();
        Resource policy = m.createResource();
        m.add(policy, RDF.type, OntDocManagerVocab.DocumentManagerPolicy);
        m.addLiteral(policy, OntDocManagerVocab.cacheModels, false);
        OntDocumentManager mgr = new OntDocumentManager((String)null);
        TestOntDocumentManager.assertTrue(mgr.getCacheModels());
        mgr.configure(m);
        TestOntDocumentManager.assertFalse("Docmgr configure() should have updated cache models flag", mgr.getCacheModels());
    }

    public void testReset() {
        OntDocumentManager mgr = new OntDocumentManager((String)null);
        TestOntDocumentManager.assertTrue(mgr.getProcessImports());
        mgr.setProcessImports(false);
        TestOntDocumentManager.assertFalse(mgr.getProcessImports());
        mgr.reset();
        TestOntDocumentManager.assertTrue(mgr.getProcessImports());
        mgr.setMetadataSearchPath("file:foo.xml", true);
        TestOntDocumentManager.assertEquals("file:foo.xml", mgr.getMetadataSearchPath());
        mgr.reset();
        TestOntDocumentManager.assertEquals("file:foo.xml", mgr.getMetadataSearchPath());
        TestOntDocumentManager.assertTrue(mgr.getCacheModels());
        mgr.setCacheModels(false);
        TestOntDocumentManager.assertFalse(mgr.getCacheModels());
        mgr.reset();
        TestOntDocumentManager.assertTrue(mgr.getCacheModels());
        TestOntDocumentManager.assertTrue(mgr.useDeclaredPrefixes());
        mgr.setUseDeclaredPrefixes(false);
        TestOntDocumentManager.assertFalse(mgr.useDeclaredPrefixes());
        mgr.reset();
        TestOntDocumentManager.assertTrue(mgr.useDeclaredPrefixes());
    }

    public void testDoAltMapping() {
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertEquals("file:vocabularies/owl.owl", odm.doAltURLMapping("http://www.w3.org/2002/07/owl"));
        TestOntDocumentManager.assertEquals("http://example.com/nocache", odm.doAltURLMapping("http://example.com/nocache"));
    }

    public void testGetLanguage() {
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertEquals(ProfileRegistry.OWL_LANG, odm.getLanguage("http://www.w3.org/2002/07/owl"));
        TestOntDocumentManager.assertNull(odm.getLanguage("http://example.com/notthere"));
    }

    public void testGetPrefixForURI() {
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertEquals("owl", odm.getPrefixForURI("http://www.w3.org/2002/07/owl#"));
        TestOntDocumentManager.assertNull(odm.getPrefixForURI("http://example.com/notthere"));
    }

    public void testGetURIForPrefix() {
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertEquals("http://www.w3.org/2002/07/owl#", odm.getURIForPrefix("owl"));
        TestOntDocumentManager.assertNull(odm.getURIForPrefix("http://example.com/notthere"));
    }

    public void testAddModel0() {
        OntDocumentManager odm = OntDocumentManager.getInstance();
        Model m = ModelFactory.createDefaultModel();
        String uri = "http://example.com/test#m";
        TestOntDocumentManager.assertNull(odm.getModel(uri));
        odm.addModel(uri, m);
        TestOntDocumentManager.assertSame(m, odm.getModel(uri));
    }

    public void testAddModel1() {
        OntDocumentManager odm = OntDocumentManager.getInstance();
        Model m0 = ModelFactory.createDefaultModel();
        Model m1 = ModelFactory.createDefaultModel();
        String uri = "http://example.com/test#m";
        TestOntDocumentManager.assertNull(odm.getModel(uri));
        odm.addModel(uri, m0);
        odm.addModel(uri, m1);
        TestOntDocumentManager.assertSame(m0, odm.getModel(uri));
        odm.addModel(uri, m1, true);
        TestOntDocumentManager.assertSame(m1, odm.getModel(uri));
    }

    public void testClearCache() {
        OntDocumentManager odm = OntDocumentManager.getInstance();
        Model m = ModelFactory.createDefaultModel();
        String uri = "http://example.com/test#m";
        TestOntDocumentManager.assertNull(odm.getModel(uri));
        odm.addModel(uri, m);
        odm.clearCache();
        TestOntDocumentManager.assertSame(null, odm.getModel(uri));
    }

    public void testForget() {
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertEquals("file:vocabularies/owl.owl", odm.doAltURLMapping("http://www.w3.org/2002/07/owl"));
        TestOntDocumentManager.assertEquals("http://www.w3.org/2002/07/owl#", odm.getLanguage("http://www.w3.org/2002/07/owl"));
        OntModel m = ModelFactory.createOntologyModel();
        odm.addModel("http://www.w3.org/2002/07/owl#", m);
        TestOntDocumentManager.assertNotNull(odm.getModel("http://www.w3.org/2002/07/owl#"));
        odm.forget("http://www.w3.org/2002/07/owl#");
        odm.forget("http://www.w3.org/2002/07/owl");
        TestOntDocumentManager.assertEquals("http://www.w3.org/2002/07/owl", odm.doAltURLMapping("http://www.w3.org/2002/07/owl"));
        TestOntDocumentManager.assertNull(odm.getLanguage("http://www.w3.org/2002/07/owl"));
        TestOntDocumentManager.assertNull(odm.getModel("http://www.w3.org/2002/07/owl#"));
    }

    public void testGetOntology() {
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        OntModel m = odm.getOntology("http://www.w3.org/2002/07/owl", OntModelSpec.OWL_MEM);
        TestOntDocumentManager.assertNotNull(m);
        TestOntDocumentManager.assertSame(odm, m.getDocumentManager());
        OntModel m1 = odm.getOntology("http://www.w3.org/2002/07/owl", OntModelSpec.OWL_MEM);
        TestOntDocumentManager.assertSame(m, m1);
    }

    public void testProcessImports() {
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertTrue(odm.getProcessImports());
        odm.setProcessImports(false);
        TestOntDocumentManager.assertFalse(odm.getProcessImports());
    }

    public void testCacheModels() {
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertTrue(odm.getCacheModels());
        odm.setCacheModels(false);
        TestOntDocumentManager.assertFalse(odm.getCacheModels());
    }

    public void testManualAssociation() {
        OntDocumentManager odm = new OntDocumentManager((String)null);
        odm.addPrefixMapping("http://www.w3.org/2002/07/owl#", "owl");
        TestOntDocumentManager.assertEquals("prefix for owl not correct", "owl", odm.getPrefixForURI("http://www.w3.org/2002/07/owl#"));
        TestOntDocumentManager.assertEquals("URI for owl not correct", "http://www.w3.org/2002/07/owl#", odm.getURIForPrefix("owl"));
        odm.addAltEntry("http://www.w3.org/2002/07/owl", "file:foo.bar");
        TestOntDocumentManager.assertEquals("Failed to retrieve cache location", "file:foo.bar", odm.doAltURLMapping("http://www.w3.org/2002/07/owl"));
        odm.addLanguageEntry("http://www.w3.org/2002/07/owl", "http://www.w3.org/2002/07/owl");
        TestOntDocumentManager.assertEquals("Failed to retrieve language", "http://www.w3.org/2002/07/owl", odm.getLanguage("http://www.w3.org/2002/07/owl"));
    }

    public void testIgnoreImport() {
        OntDocumentManager odm = new OntDocumentManager();
        TestUtil.assertIteratorLength(odm.listIgnoredImports(), 0);
        odm.addIgnoreImport("file:testing/ontology/testImport3/c.owl");
        TestUtil.assertIteratorLength(odm.listIgnoredImports(), 1);
        TestOntDocumentManager.assertTrue(odm.ignoringImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertFalse(odm.ignoringImport("file:testing/ontology/foo.owl"));
        OntModelSpec spec = new OntModelSpec(null, odm, null, ProfileRegistry.OWL_LANG);
        OntModel m = ModelFactory.createOntologyModel(spec, null);
        TestOntDocumentManager.assertNotNull("Ontology model should not be null", m);
        m.read("file:testing/ontology/testImport3/a.owl");
        TestOntDocumentManager.assertEquals("Marker count not correct", 2, TestOntDocumentManager.countMarkers(m));
        odm.removeIgnoreImport("file:testing/ontology/testImport3/c.owl");
        TestUtil.assertIteratorLength(odm.listIgnoredImports(), 0);
        TestOntDocumentManager.assertFalse(odm.ignoringImport("file:testing/ontology/testImport3/c.owl"));
    }

    public void testUnloadImport1() {
        OntModel m = ModelFactory.createOntologyModel();
        m.read("file:testing/ontology/testImport3/a.owl");
        TestOntDocumentManager.assertEquals("Marker count not correct", 3, TestOntDocumentManager.countMarkers(m));
        TestOntDocumentManager.assertTrue("c should be imported", m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        m.getDocumentManager().unloadImport(m, "file:testing/ontology/testImport3/c.owl");
        TestOntDocumentManager.assertEquals("Marker count not correct", 2, TestOntDocumentManager.countMarkers(m));
        TestOntDocumentManager.assertFalse("c should not be imported", m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
    }

    public void testUnloadImport2() {
        OntModel m = ModelFactory.createOntologyModel();
        m.read("file:testing/ontology/testImport3/a.owl");
        TestOntDocumentManager.assertEquals("Marker count not correct", 3, TestOntDocumentManager.countMarkers(m));
        TestOntDocumentManager.assertTrue("c should be imported", m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertTrue("b should be imported", m.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
        m.getDocumentManager().unloadImport(m, "file:testing/ontology/testImport3/b.owl");
        TestOntDocumentManager.assertEquals("Marker count not correct", 1, TestOntDocumentManager.countMarkers(m));
        TestOntDocumentManager.assertFalse("c should not be imported", m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertFalse("b should not be imported", m.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
    }

    public void testUnloadImport3() {
        OntModel m = ModelFactory.createOntologyModel();
        m.read("file:testing/ontology/testImport6/a.owl");
        TestOntDocumentManager.assertEquals("Marker count not correct", 4, TestOntDocumentManager.countMarkers(m));
        TestOntDocumentManager.assertTrue("c should be imported", m.hasLoadedImport("file:testing/ontology/testImport6/c.owl"));
        TestOntDocumentManager.assertTrue("b should be imported", m.hasLoadedImport("file:testing/ontology/testImport6/b.owl"));
        TestOntDocumentManager.assertTrue("d should be imported", m.hasLoadedImport("file:testing/ontology/testImport6/d.owl"));
        m.getDocumentManager().unloadImport(m, "file:testing/ontology/testImport6/b.owl");
        TestOntDocumentManager.assertEquals("Marker count not correct", 3, TestOntDocumentManager.countMarkers(m));
        TestOntDocumentManager.assertTrue("c should be imported", m.hasLoadedImport("file:testing/ontology/testImport6/c.owl"));
        TestOntDocumentManager.assertTrue("d should be imported", m.hasLoadedImport("file:testing/ontology/testImport6/d.owl"));
        TestOntDocumentManager.assertFalse("b should not be imported", m.hasLoadedImport("file:testing/ontology/testImport6/b.owl"));
    }

    public void testDynamicImports1() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource a = m.getResource("file:testing/ontology/testImport3/a.owl");
        Resource b = m.getResource("file:testing/ontology/testImport3/b.owl");
        m.add(a, m.getProfile().IMPORTS(), b);
        TestOntDocumentManager.assertEquals("Marker count not correct", 0, TestOntDocumentManager.countMarkers(m));
        TestOntDocumentManager.assertFalse("c should not be imported", m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertFalse("b should not be imported", m.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
    }

    public void testDynamicImports2() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource a = m.getResource("file:testing/ontology/testImport3/a.owl");
        Resource b = m.getResource("file:testing/ontology/testImport3/b.owl");
        m.setDynamicImports(true);
        m.add(a, m.getProfile().IMPORTS(), b);
        TestOntDocumentManager.assertEquals("Marker count not correct", 2, TestOntDocumentManager.countMarkers(m));
        TestOntDocumentManager.assertTrue("c should be imported", m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertTrue("b should be imported", m.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
    }

    public void testDynamicImports3() {
        OntModel m = ModelFactory.createOntologyModel();
        m.read("file:testing/ontology/testImport3/a.owl");
        TestOntDocumentManager.assertEquals("Marker count not correct", 3, TestOntDocumentManager.countMarkers(m));
        TestOntDocumentManager.assertTrue("c should be imported", m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertTrue("b should be imported", m.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
        m.setDynamicImports(true);
        Resource a = m.getResource("file:testing/ontology/testImport3/a.owl");
        Resource b = m.getResource("file:testing/ontology/testImport3/b.owl");
        m.remove(m.createStatement(a, m.getProfile().IMPORTS(), b));
        TestOntDocumentManager.assertEquals("Marker count not correct", 1, TestOntDocumentManager.countMarkers(m));
        TestOntDocumentManager.assertFalse("c should not be imported", m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertFalse("b should not be imported", m.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
    }

    public void testSearchPath() {
        OntDocumentManager o1 = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertEquals("Did not return correct loaded search path", "file:etc/ont-policy-test.rdf", o1.getLoadedPolicyURL());
        OntDocumentManager o2 = new OntDocumentManager("file:etc/ont-policy-test.notexist.rdf;file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertEquals("Did not return correct loaded search path", "file:etc/ont-policy-test.rdf", o2.getLoadedPolicyURL());
        OntDocumentManager o3 = new OntDocumentManager((String)null);
        TestOntDocumentManager.assertNull("Most recent policy should be null", o3.getLoadedPolicyURL());
        o3.setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
        TestOntDocumentManager.assertEquals("Did not return correct loaded search path", "file:etc/ont-policy-test.rdf", o2.getLoadedPolicyURL());
        o3.setMetadataSearchPath("file:etc/ont-policy-test.notexist.rdf", true);
        TestOntDocumentManager.assertNull("Most recent policy should be null", o3.getLoadedPolicyURL());
    }

    public void testReadFailHandler0() {
        OntDocumentManager o1 = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertNull(o1.getReadFailureHandler());
        OntDocumentManager.ReadFailureHandler rfh = new OntDocumentManager.ReadFailureHandler(){

            public void handleFailedRead(String url, Model model, Exception e2) {
            }
        };
        o1.setReadFailureHandler(rfh);
        TestOntDocumentManager.assertSame(rfh, o1.getReadFailureHandler());
    }

    public void testReadFailHandler1() {
        OntDocumentManager o1 = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestFailHandler rfh = new TestFailHandler();
        o1.setReadFailureHandler(rfh);
        String source = "@prefix owl: <http://www.w3.org/2002/07/owl#> . <> a owl:Ontology ; owl:imports <http://example.com/not/exist>. ";
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        spec.setDocumentManager(o1);
        OntModel m = ModelFactory.createOntologyModel(spec);
        m.read(new StringReader(source), "http://example.com/foo#", "N3");
        TestOntDocumentManager.assertTrue(rfh.m_seen);
    }

    public void testReadHook0() {
        TestReadHook rh = new TestReadHook(false);
        OntDocumentManager o1 = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        o1.setReadHook(rh);
        o1.reset();
        String source = "@prefix owl: <http://www.w3.org/2002/07/owl#> . <> a owl:Ontology ; owl:imports <file:testing/ontology/testImport3/a.owl>. ";
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        spec.setDocumentManager(o1);
        OntModel m = ModelFactory.createOntologyModel(spec);
        m.read(new StringReader(source), "http://example.com/foo#", "N3");
        TestOntDocumentManager.assertEquals("Wrong number of calls to before load hook", 3, rh.m_before);
        TestOntDocumentManager.assertEquals("Wrong number of calls to before load hook", 3, rh.m_after);
    }

    public void testReadHook1() {
        TestReadHook rh = new TestReadHook(true);
        OntDocumentManager o1 = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        o1.setReadHook(rh);
        o1.reset();
        String source = "@prefix owl: <http://www.w3.org/2002/07/owl#> . <> a owl:Ontology ; owl:imports <file:testing/ontology/testImport3/a.owl>. ";
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        spec.setDocumentManager(o1);
        OntModel m = ModelFactory.createOntologyModel(spec);
        m.read(new StringReader(source), "http://example.com/foo#", "N3");
        TestOntDocumentManager.assertEquals("Wrong number of calls to before load hook", 1, rh.m_before);
        TestOntDocumentManager.assertEquals("Wrong number of calls to after load hook", 1, rh.m_after);
    }

    public static int countMarkers(Model m) {
        int count = 0;
        Resource marker = m.getResource("http://jena.hpl.hp.com/2003/03/testont#Marker");
        StmtIterator i = m.listStatements(null, RDF.type, marker);
        while (i.hasNext()) {
            ++count;
            i.next();
        }
        return count;
    }

    static class TestReadHook
    implements OntDocumentManager.ReadHook {
        private int m_before = 0;
        private int m_after = 0;
        private boolean m_renaming = false;

        TestReadHook(boolean renaming) {
            this.m_renaming = renaming;
        }

        public void afterRead(Model model, String source, OntDocumentManager odm) {
            ++this.m_after;
        }

        public String beforeRead(Model model, String source, OntDocumentManager odm) {
            if (this.m_renaming) {
                ++this.m_before;
                return "file:testing/ontology/testImport3/c.owl";
            }
            ++this.m_before;
            return source;
        }
    }

    static class TestFailHandler
    implements OntDocumentManager.ReadFailureHandler {
        public boolean m_seen = false;

        TestFailHandler() {
        }

        public void handleFailedRead(String url, Model model, Exception e2) {
            this.m_seen = true;
            log.debug("Seeing failed read of " + url, e2);
        }
    }

    static class DocManagerImportTest
    extends TestCase {
        String m_dir;
        int m_count;
        String m_path;
        boolean m_processImports;

        DocManagerImportTest(String dir, int count, boolean processImports, String path) {
            super(dir);
            this.m_dir = dir;
            this.m_count = count;
            this.m_path = path;
            this.m_processImports = processImports;
        }

        public void runTest() {
            OntDocumentManager dm = new OntDocumentManager();
            dm.setProcessImports(this.m_processImports);
            if (this.m_path != null) {
                dm.setMetadataSearchPath(this.m_path, true);
            }
            OntModelSpec spec = new OntModelSpec(null, dm, null, ProfileRegistry.OWL_LANG);
            OntModel m = ModelFactory.createOntologyModel(spec, null);
            DocManagerImportTest.assertNotNull("Ontology model should not be null", m);
            m.read("file:" + this.m_dir + "/a.owl");
            DocManagerImportTest.assertEquals("Marker count not correct", this.m_count, TestOntDocumentManager.countMarkers(m));
        }
    }
}

