/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.util.ThreadStats;

public class ThreadWatcher {
    long start = 0L;
    long totalWait = 0L;
    long totalTime = 0L;
    long waitCount = 0L;
    long runCount = 0L;

    public void addWait(long totalWaitNanos, long now2) {
        if (this.start == 0L) {
            this.start = now2;
        } else {
            this.totalWait += totalWaitNanos;
            this.totalTime += now2 - this.start;
            this.start = now2;
        }
        ++this.waitCount;
    }

    public long incrementRunCount() {
        long now2 = System.nanoTime();
        if (this.start == 0L) {
            this.start = now2;
        } else {
            this.totalTime += now2 - this.start;
            this.start = now2;
        }
        return this.runCount++;
    }

    public ThreadStats publish(boolean running) {
        long now2 = System.nanoTime();
        this.totalTime += now2 - this.start;
        long totalRun = this.totalTime - this.totalWait;
        int utilizationPercentage = this.totalTime <= 0L || this.runCount <= 1L ? 0 : (int)(totalRun * 100L / this.totalTime);
        ThreadStats threadStats = new ThreadStats(utilizationPercentage, this.runCount, this.waitCount, running);
        this.start = now2;
        this.totalTime = 0L;
        this.totalWait = 0L;
        return threadStats;
    }
}

