/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4.statements;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.junit.internal.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.springframework.test.context.TestContextManager;

public class RunAfterTestMethodCallbacks
extends Statement {
    private final Statement next;
    private final Object testInstance;
    private final Method testMethod;
    private final TestContextManager testContextManager;

    public RunAfterTestMethodCallbacks(Statement next, Object testInstance, Method testMethod, TestContextManager testContextManager) {
        this.next = next;
        this.testInstance = testInstance;
        this.testMethod = testMethod;
        this.testContextManager = testContextManager;
    }

    public void evaluate() throws Throwable {
        Throwable testException = null;
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            this.next.evaluate();
        }
        catch (Throwable e2) {
            testException = e2;
            errors.add(e2);
        }
        try {
            this.testContextManager.afterTestMethod(this.testInstance, this.testMethod, testException);
        }
        catch (Exception e3) {
            errors.add(e3);
        }
        if (errors.isEmpty()) {
            return;
        }
        if (errors.size() == 1) {
            throw (Throwable)errors.get(0);
        }
        throw new MultipleFailureException(errors);
    }
}

