/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.NamedQuery;
import org.springframework.data.jpa.repository.query.PartTreeJpaQuery;
import org.springframework.data.jpa.repository.query.QueryExtractor;
import org.springframework.data.jpa.repository.query.SimpleJpaQuery;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;

public final class JpaQueryLookupStrategy {
    private JpaQueryLookupStrategy() {
    }

    public static QueryLookupStrategy create(EntityManager em, QueryLookupStrategy.Key key, QueryExtractor extractor) {
        if (key == null) {
            return new CreateIfNotFoundQueryLookupStrategy(em, extractor);
        }
        switch (key) {
            case CREATE: {
                return new CreateQueryLookupStrategy(em, extractor);
            }
            case USE_DECLARED_QUERY: {
                return new DeclaredQueryLookupStrategy(em, extractor);
            }
            case CREATE_IF_NOT_FOUND: {
                return new CreateIfNotFoundQueryLookupStrategy(em, extractor);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported query lookup strategy %s!", new Object[]{key}));
    }

    private static class CreateIfNotFoundQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        private final DeclaredQueryLookupStrategy strategy;
        private final CreateQueryLookupStrategy createStrategy;

        public CreateIfNotFoundQueryLookupStrategy(EntityManager em, QueryExtractor extractor) {
            super(em, extractor);
            this.strategy = new DeclaredQueryLookupStrategy(em, extractor);
            this.createStrategy = new CreateQueryLookupStrategy(em, extractor);
        }

        @Override
        protected RepositoryQuery resolveQuery(JpaQueryMethod method, EntityManager em, NamedQueries namedQueries) {
            try {
                return this.strategy.resolveQuery(method, em, namedQueries);
            }
            catch (IllegalStateException e2) {
                return this.createStrategy.resolveQuery(method, em, namedQueries);
            }
        }
    }

    private static class DeclaredQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        public DeclaredQueryLookupStrategy(EntityManager em, QueryExtractor extractor) {
            super(em, extractor);
        }

        @Override
        protected RepositoryQuery resolveQuery(JpaQueryMethod method, EntityManager em, NamedQueries namedQueries) {
            RepositoryQuery query2 = SimpleJpaQuery.fromQueryAnnotation(method, em);
            if (null != query2) {
                return query2;
            }
            String name = method.getNamedQueryName();
            if (namedQueries.hasQuery(name)) {
                return new SimpleJpaQuery(method, em, namedQueries.getQuery(name));
            }
            query2 = NamedQuery.lookupFrom(method, em);
            if (null != query2) {
                return query2;
            }
            throw new IllegalStateException(String.format("Did neither find a NamedQuery nor an annotated query for method %s!", method));
        }
    }

    private static class CreateQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        public CreateQueryLookupStrategy(EntityManager em, QueryExtractor extractor) {
            super(em, extractor);
        }

        @Override
        protected RepositoryQuery resolveQuery(JpaQueryMethod method, EntityManager em, NamedQueries namedQueries) {
            try {
                return new PartTreeJpaQuery(method, em);
            }
            catch (IllegalArgumentException e2) {
                throw new IllegalArgumentException(String.format("Could not create query metamodel for method %s!", method.toString()), e2);
            }
        }
    }

    private static abstract class AbstractQueryLookupStrategy
    implements QueryLookupStrategy {
        private final EntityManager em;
        private final QueryExtractor provider;

        public AbstractQueryLookupStrategy(EntityManager em, QueryExtractor extractor) {
            this.em = em;
            this.provider = extractor;
        }

        @Override
        public final RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, NamedQueries namedQueries) {
            return this.resolveQuery(new JpaQueryMethod(method, metadata, this.provider), this.em, namedQueries);
        }

        protected abstract RepositoryQuery resolveQuery(JpaQueryMethod var1, EntityManager var2, NamedQueries var3);
    }
}

