/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.ReplicationMode;
import org.hibernate.TransientObjectException;
import org.hibernate.engine.Cascade;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.event.EventSource;
import org.hibernate.event.ReplicateEvent;
import org.hibernate.event.ReplicateEventListener;
import org.hibernate.event.def.AbstractSaveEventListener;
import org.hibernate.event.def.OnReplicateVisitor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReplicateEventListener
extends AbstractSaveEventListener
implements ReplicateEventListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultReplicateEventListener.class);

    public void onReplicate(ReplicateEvent event) {
        EventSource source = event.getSession();
        if (source.getPersistenceContext().reassociateIfUninitializedProxy(event.getObject())) {
            log.trace("uninitialized proxy passed to replicate()");
            return;
        }
        Object entity = source.getPersistenceContext().unproxyAndReassociate(event.getObject());
        if (source.getPersistenceContext().isEntryFor(entity)) {
            log.trace("ignoring persistent instance passed to replicate()");
            return;
        }
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        Serializable id = persister.getIdentifier(entity, source);
        if (id == null) {
            throw new TransientObjectException("instance with null id passed to replicate()");
        }
        ReplicationMode replicationMode = event.getReplicationMode();
        Object oldVersion = replicationMode == ReplicationMode.EXCEPTION ? null : persister.getCurrentVersion(id, source);
        if (oldVersion != null) {
            Object realOldVersion;
            boolean canReplicate;
            if (log.isTraceEnabled()) {
                log.trace("found existing row for " + MessageHelper.infoString(persister, id, source.getFactory()));
            }
            if (canReplicate = replicationMode.shouldOverwriteCurrentVersion(entity, realOldVersion = persister.isVersioned() ? oldVersion : null, persister.getVersion(entity, source.getEntityMode()), persister.getVersionType())) {
                this.performReplication(entity, id, realOldVersion, persister, replicationMode, source);
            } else {
                log.trace("no need to replicate");
            }
        } else {
            boolean regenerate;
            if (log.isTraceEnabled()) {
                log.trace("no existing row, replicating new instance " + MessageHelper.infoString(persister, id, source.getFactory()));
            }
            EntityKey key = (regenerate = persister.isIdentifierAssignedByInsert()) ? null : new EntityKey(id, persister, source.getEntityMode());
            this.performSaveOrReplicate(entity, key, persister, regenerate, replicationMode, source, true);
        }
    }

    protected boolean visitCollectionsBeforeSave(Object entity, Serializable id, Object[] values, Type[] types, EventSource source) {
        OnReplicateVisitor visitor = new OnReplicateVisitor(source, id, entity, false);
        visitor.processEntityPropertyValues(values, types);
        return super.visitCollectionsBeforeSave(entity, id, values, types, source);
    }

    protected boolean substituteValuesIfNecessary(Object entity, Serializable id, Object[] values, EntityPersister persister, SessionImplementor source) {
        return false;
    }

    protected boolean isVersionIncrementDisabled() {
        return true;
    }

    private void performReplication(Object entity, Serializable id, Object version2, EntityPersister persister, ReplicationMode replicationMode, EventSource source) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace("replicating changes to " + MessageHelper.infoString(persister, id, source.getFactory()));
        }
        new OnReplicateVisitor(source, id, entity, true).process(entity, persister);
        source.getPersistenceContext().addEntity(entity, persister.isMutable() ? Status.MANAGED : Status.READ_ONLY, null, new EntityKey(id, persister, source.getEntityMode()), version2, LockMode.NONE, true, persister, true, false);
        this.cascadeAfterReplicate(entity, persister, replicationMode, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeAfterReplicate(Object entity, EntityPersister persister, ReplicationMode replicationMode, EventSource source) {
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(CascadingAction.REPLICATE, 0, source).cascade(persister, entity, replicationMode);
            Object var6_5 = null;
            source.getPersistenceContext().decrementCascadeLevel();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            source.getPersistenceContext().decrementCascadeLevel();
            throw throwable;
        }
    }

    protected CascadingAction getCascadeAction() {
        return CascadingAction.REPLICATE;
    }
}

