/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.types.v2;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang.StringUtils;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.LogEntry;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.util.ChecksumUtil;
import org.dataone.service.types.v2.SystemMetadata;

public class TypeFactory
extends org.dataone.service.types.v1.TypeFactory {
    public static SystemMetadata buildMinimalSystemMetadata(Identifier id, InputStream data, String checksumAlgorithm, ObjectFormatIdentifier formatId, Subject submitterRightsHolder) throws NoSuchAlgorithmException, IOException, NotFound, ServiceFailure {
        SystemMetadata sm = new SystemMetadata();
        sm.setIdentifier(id);
        sm.setFormatId(formatId);
        CountingInputStream cis = new CountingInputStream(data);
        if (checksumAlgorithm == null) {
            checksumAlgorithm = "MD5";
        }
        Checksum checksum = ChecksumUtil.checksum(cis, checksumAlgorithm);
        sm.setChecksum(checksum);
        sm.setSize(new BigInteger(String.valueOf(cis.getByteCount())));
        cis.close();
        sm.setSerialVersion(BigInteger.ONE);
        sm.setSubmitter(submitterRightsHolder);
        sm.setRightsHolder(submitterRightsHolder);
        Date now2 = new Date();
        sm.setDateUploaded(now2);
        sm.setDateSysMetadataModified(now2);
        return sm;
    }

    public static <T> T convertTypeFromType(Object original, Class<T> destinationClass) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (original.getClass().getCanonicalName().equals(destinationClass.getCanonicalName())) {
            return (T)original;
        }
        if (destinationClass.isEnum()) {
            T[] consts;
            for (T c : consts = destinationClass.getEnumConstants()) {
                if (!c.toString().equalsIgnoreCase(original.toString())) continue;
                return c;
            }
            throw new InstantiationException(String.format("Could not find %s Enum element for '%s'", destinationClass.getCanonicalName(), original.toString()));
        }
        T destInstance = destinationClass.newInstance();
        Map<String, String> propMap = BeanUtils.describe(original);
        if (logger.isDebugEnabled()) {
            logger.debug("BeanUtils.describe produces map of size: " + propMap.size());
        }
        for (Map.Entry<String, String> propTypePair : propMap.entrySet()) {
            String valueClass;
            String propName = propTypePair.getKey();
            if (propName.equals("class") || (valueClass = propTypePair.getValue()) == null) continue;
            String readMethodName = "get" + StringUtils.capitalize(propName);
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("%s : %s", propName, valueClass));
            }
            try {
                Class<?> origType = TypeFactory.getReturnType(original, propName);
                Class<?> destType = TypeFactory.getReturnType(destInstance, propName);
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("  Copying property '%s', type '%s' ==> '%s'", propName, origType.getCanonicalName(), destType.getCanonicalName()));
                }
                if (propName.endsWith("List")) {
                    int i = 0;
                    try {
                        while (true) {
                            block21: {
                                Object listItem = PropertyUtils.getIndexedProperty(original, propName, i);
                                logger.trace("    Got indexed Property: " + listItem.toString());
                                Class<?> destListType = TypeFactory.getListReturnType(destInstance, propName);
                                if (logger.isTraceEnabled()) {
                                    logger.trace(String.format("    [%d] Copying Indexed property '%s', type '%s' ==> '%s'", i, propName, listItem.getClass().getCanonicalName(), destListType.getCanonicalName()));
                                }
                                if (destListType == listItem.getClass()) {
                                    TypeFactory.addIndexedProperty(destInstance, propName, listItem);
                                } else {
                                    try {
                                        TypeFactory.addIndexedProperty(destInstance, propName, TypeFactory.convertTypeFromType(listItem, destListType));
                                    }
                                    catch (InstantiationException e2) {
                                        if (destListType.equals(LogEntry.class)) break block21;
                                        throw e2;
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                    catch (IndexOutOfBoundsException e3) {
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace(String.format("    for indexed property '%s', copied %d elements", propName, i));
                        continue;
                    }
                    catch (NoSuchMethodException e4) {
                        e4.printStackTrace();
                        continue;
                    }
                }
                if (origType == Boolean.TYPE) {
                    readMethodName = readMethodName.replaceFirst("get", "is");
                }
                Method m = original.getClass().getMethod(readMethodName, null);
                if (destType == origType) {
                    BeanUtils.copyProperty(destInstance, propName, PropertyUtils.getSimpleProperty(original, propName));
                    continue;
                }
                BeanUtils.copyProperty(destInstance, propName, TypeFactory.convertTypeFromType(PropertyUtils.getSimpleProperty(original, propName), destType));
            }
            catch (NoSuchMethodException e5) {
                logger.debug("  caught NoSuchMethodException - no corresponding property in destination type");
            }
        }
        return destInstance;
    }

    private static Class<?> getReturnType(Object o, String property) throws SecurityException, NoSuchMethodException {
        String methodName = "get" + StringUtils.capitalize(property);
        try {
            return o.getClass().getMethod(methodName, new Class[0]).getReturnType();
        }
        catch (NoSuchMethodException e2) {
            methodName = "is" + StringUtils.capitalize(property);
            return o.getClass().getMethod(methodName, new Class[0]).getReturnType();
        }
    }

    private static Class<?> getListReturnType(Object o, String property) throws NoSuchMethodException, SecurityException {
        String methodName = "get" + StringUtils.capitalize(property.substring(0, property.length() - 4));
        return o.getClass().getMethod(methodName, Integer.TYPE).getReturnType();
    }

    private static void addIndexedProperty(Object destinationInstance, String propName, Object valueObject) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method addMethod = destinationInstance.getClass().getMethod("add" + StringUtils.capitalize(propName).substring(0, propName.length() - 4), valueObject.getClass());
        addMethod.invoke(destinationInstance, valueObject);
    }
}

