/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.types;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.http.client.HttpClient;

public class AutoCloseHttpClientInputStream
extends AutoCloseInputStream {
    private InputStream is;
    private HttpClient hc;

    public AutoCloseHttpClientInputStream(InputStream is, HttpClient hc) {
        super(is);
        this.hc = hc;
    }

    @Override
    protected void afterRead(int n) throws IOException {
        if (n == -1) {
            this.close();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        catch (IOException iOException) {
        }
        finally {
            if (this.hc != null && this.hc instanceof Closeable) {
                ((Closeable)((Object)this.hc)).close();
            }
            this.hc = null;
        }
    }

    @Override
    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

