/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.dbcp.AbandonedTrace;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingResultSet;

public class DelegatingStatement
extends AbandonedTrace
implements Statement {
    protected Statement _stmt = null;
    protected DelegatingConnection _conn = null;
    protected boolean _closed = false;

    public DelegatingStatement(DelegatingConnection c, Statement s) {
        super(c);
        this._stmt = s;
        this._conn = c;
    }

    public Statement getDelegate() {
        return this._stmt;
    }

    public boolean equals(Object obj) {
        Statement delegate = this.getInnermostDelegate();
        if (delegate == null) {
            return false;
        }
        if (obj instanceof DelegatingStatement) {
            DelegatingStatement s = (DelegatingStatement)obj;
            return delegate.equals(s.getInnermostDelegate());
        }
        return delegate.equals(obj);
    }

    public int hashCode() {
        Statement obj = this.getInnermostDelegate();
        if (obj == null) {
            return 0;
        }
        return obj.hashCode();
    }

    public Statement getInnermostDelegate() {
        Statement s = this._stmt;
        while (s != null && s instanceof DelegatingStatement) {
            if (this != (s = ((DelegatingStatement)s).getDelegate())) continue;
            return null;
        }
        return s;
    }

    public void setDelegate(Statement s) {
        this._stmt = s;
    }

    protected boolean isClosed() {
        return this._closed;
    }

    protected void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(this.getClass().getName() + " with address: \"" + this.toString() + "\" is closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            try {
                List resultSets;
                if (this._conn != null) {
                    this._conn.removeTrace(this);
                    this._conn = null;
                }
                if ((resultSets = this.getTrace()) != null) {
                    ResultSet[] set = resultSets.toArray(new ResultSet[resultSets.size()]);
                    for (int i = 0; i < set.length; ++i) {
                        set[i].close();
                    }
                    this.clearTrace();
                }
                this._stmt.close();
            }
            catch (SQLException e2) {
                this.handleException(e2);
            }
        }
        finally {
            this._closed = true;
        }
    }

    protected void handleException(SQLException e2) throws SQLException {
        if (this._conn == null) {
            throw e2;
        }
        this._conn.handleException(e2);
    }

    protected void activate() throws SQLException {
        if (this._stmt instanceof DelegatingStatement) {
            ((DelegatingStatement)this._stmt).activate();
        }
    }

    protected void passivate() throws SQLException {
        if (this._stmt instanceof DelegatingStatement) {
            ((DelegatingStatement)this._stmt).passivate();
        }
    }

    public Connection getConnection() throws SQLException {
        this.checkOpen();
        return this._conn;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this, this._stmt.executeQuery(sql));
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this, this._stmt.getResultSet());
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.executeUpdate(sql);
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return 0;
        }
    }

    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getMaxFieldSize();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return 0;
        }
    }

    public void setMaxFieldSize(int max2) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setMaxFieldSize(max2);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public int getMaxRows() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getMaxRows();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return 0;
        }
    }

    public void setMaxRows(int max2) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setMaxRows(max2);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setEscapeProcessing(enable);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getQueryTimeout();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return 0;
        }
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setQueryTimeout(seconds);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public void cancel() throws SQLException {
        this.checkOpen();
        try {
            this._stmt.cancel();
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getWarnings();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public void clearWarnings() throws SQLException {
        this.checkOpen();
        try {
            this._stmt.clearWarnings();
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setCursorName(name);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public boolean execute(String sql) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.execute(sql);
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return false;
        }
    }

    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getUpdateCount();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return 0;
        }
    }

    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getMoreResults();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return false;
        }
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setFetchDirection(direction);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getFetchDirection();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return 0;
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setFetchSize(rows);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public int getFetchSize() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getFetchSize();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return 0;
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getResultSetConcurrency();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return 0;
        }
    }

    public int getResultSetType() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getResultSetType();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return 0;
        }
    }

    public void addBatch(String sql) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.addBatch(sql);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public void clearBatch() throws SQLException {
        this.checkOpen();
        try {
            this._stmt.clearBatch();
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.executeBatch();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public String toString() {
        return this._stmt.toString();
    }

    public boolean getMoreResults(int current) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getMoreResults(current);
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return false;
        }
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getGeneratedKeys();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return 0;
        }
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.executeUpdate(sql, columnIndexes);
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return 0;
        }
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.executeUpdate(sql, columnNames);
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return 0;
        }
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.execute(sql, autoGeneratedKeys);
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return false;
        }
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.execute(sql, columnIndexes);
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return false;
        }
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.execute(sql, columnNames);
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return false;
        }
    }

    public int getResultSetHoldability() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getResultSetHoldability();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return 0;
        }
    }
}

