/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestSuite;

public class NewRegressionObjects
extends ModelTestBase {
    protected Model m;
    protected Resource S;
    protected Property P;
    protected static int numberSubjects = 7;
    protected static int numberPredicates = 3;
    protected static final String subjectPrefix = "http://aldabaran/test6/s";
    protected static final String predicatePrefix = "http://aldabaran/test6/";

    public NewRegressionObjects(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(NewRegressionObjects.class);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void setUp() {
        this.m = this.getModel();
        this.S = this.m.createResource("http://nowhere.man/subject");
        this.P = this.m.createProperty("http://nowhere.man/predicate");
    }

    public void tearDown() {
        this.m = null;
        this.S = null;
        this.P = null;
    }

    public void testListSubjects() {
        Set statements = this.fill(this.m);
        List L = NewRegressionObjects.iteratorToList(this.m.listSubjects());
        NewRegressionObjects.assertEquals(numberSubjects, L.size());
        Set wanted = this.subjectSet(numberSubjects);
        NewRegressionObjects.assertEquals(wanted, NewRegressionObjects.iteratorToSet(L.iterator()));
    }

    public void testListNamespaces() {
        Set statements = this.fill(this.m);
        List L = NewRegressionObjects.iteratorToList(this.m.listNameSpaces());
        NewRegressionObjects.assertEquals(numberPredicates, L.size());
        Set wanted = this.predicateSet(numberPredicates);
        NewRegressionObjects.assertEquals(wanted, new HashSet(L));
    }

    public void testListStatements() {
        Set statements = this.fill(this.m);
        List L = NewRegressionObjects.iteratorToList(this.m.listStatements());
        NewRegressionObjects.assertEquals(statements.size(), L.size());
        NewRegressionObjects.assertEquals(statements, new HashSet(L));
    }

    public void testListObjectsOfPropertyByProperty() {
        Set statements = this.fill(this.m);
        List L = NewRegressionObjects.iteratorToList(this.m.listObjectsOfProperty(NewRegressionObjects.property("http://aldabaran/test6/0/p")));
        NewRegressionObjects.assertEquals(numberSubjects, L.size());
        Set wanted = this.literalsFor(0);
        NewRegressionObjects.assertEquals(wanted, new HashSet(L));
    }

    public void testListObjectsOfPropertyBySubject() {
        int size = 10;
        Resource s = this.m.createResource();
        for (int i = 0; i < size; ++i) {
            this.m.addLiteral(s, RDF.value, i);
        }
        List L = NewRegressionObjects.iteratorToList(this.m.listObjectsOfProperty(s, RDF.value));
        NewRegressionObjects.assertEquals(size, L.size());
        Set wanted = this.literalsUpto(size);
        NewRegressionObjects.assertEquals(wanted, new HashSet(L));
    }

    public void testListObjects() {
        this.fill(this.m);
        Set wanted = this.literalsUpto(numberSubjects * numberPredicates);
        NewRegressionObjects.assertEquals(wanted, NewRegressionObjects.iteratorToSet(this.m.listObjects()));
    }

    protected Set subjectSet(int limit) {
        HashSet<Resource> result = new HashSet<Resource>();
        for (int i = 0; i < limit; ++i) {
            result.add(NewRegressionObjects.resource(subjectPrefix + i));
        }
        return result;
    }

    protected Set predicateSet(int limit) {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < limit; ++i) {
            result.add(predicatePrefix + i + "/");
        }
        return result;
    }

    protected Set literalsUpto(int limit) {
        HashSet<Literal> result = new HashSet<Literal>();
        for (int i = 0; i < limit; ++i) {
            result.add(this.m.createTypedLiteral(i));
        }
        return result;
    }

    protected Set literalsFor(int predicate) {
        HashSet<Literal> result = new HashSet<Literal>();
        for (int i = 0; i < numberSubjects; ++i) {
            result.add(this.m.createTypedLiteral(i * numberPredicates + predicate));
        }
        return result;
    }

    protected Set fill(Model m) {
        HashSet<Statement> statements = new HashSet<Statement>();
        for (int i = 0; i < numberSubjects; ++i) {
            for (int j = 0; j < numberPredicates; ++j) {
                Statement s = m.createLiteralStatement(NewRegressionObjects.resource(subjectPrefix + i), NewRegressionObjects.property(predicatePrefix + j + "/p"), i * numberPredicates + j);
                m.add(s);
                statements.add(s);
            }
        }
        NewRegressionObjects.assertEquals((long)(numberSubjects * numberPredicates), m.size());
        return statements;
    }
}

