/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestGraphUtils
extends GraphTestBase {
    public TestGraphUtils(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestGraphUtils.class);
    }

    public void testFindAll() {
        final Bool foundAll = new Bool(false);
        GraphBase mock = new GraphBase(){

            public ExtendedIterator graphBaseFind(TripleMatch m) {
                Triple t = m.asTriple();
                Assert.assertEquals(Node.ANY, t.getSubject());
                Assert.assertEquals(Node.ANY, t.getPredicate());
                Assert.assertEquals(Node.ANY, t.getObject());
                foundAll.value = true;
                return null;
            }
        };
        GraphUtil.findAll(mock);
        TestGraphUtils.assertTrue("find(ANY, ANY, ANY) called", foundAll.value);
    }

    private static class Bool {
        boolean value;

        Bool(boolean value) {
            this.value = value;
        }
    }
}

