/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.embedded;

import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabase;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseFactory;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;

public class EmbeddedDatabaseBuilder {
    private final EmbeddedDatabaseFactory databaseFactory = new EmbeddedDatabaseFactory();
    private final ResourceDatabasePopulator databasePopulator = new ResourceDatabasePopulator();
    private final ResourceLoader resourceLoader;

    public EmbeddedDatabaseBuilder() {
        this(new DefaultResourceLoader());
    }

    public EmbeddedDatabaseBuilder(ResourceLoader resourceLoader) {
        this.databaseFactory.setDatabasePopulator(this.databasePopulator);
        this.resourceLoader = resourceLoader;
    }

    public EmbeddedDatabaseBuilder setName(String databaseName) {
        this.databaseFactory.setDatabaseName(databaseName);
        return this;
    }

    public EmbeddedDatabaseBuilder setType(EmbeddedDatabaseType databaseType) {
        this.databaseFactory.setDatabaseType(databaseType);
        return this;
    }

    public EmbeddedDatabaseBuilder addScript(String sqlResource) {
        this.databasePopulator.addScript(this.resourceLoader.getResource(sqlResource));
        return this;
    }

    public EmbeddedDatabaseBuilder addDefaultScripts() {
        this.addScript("schema.sql");
        this.addScript("data.sql");
        return this;
    }

    public EmbeddedDatabase build() {
        return this.databaseFactory.getDatabase();
    }
}

