/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.ldap;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.naming.directory.DirContext;
import junit.framework.Assert;
import org.dataone.cn.ldap.DirContextProvider;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirContextProviderTestUnit {
    private static final Logger log = LoggerFactory.getLogger(DirContextProviderTestUnit.class);

    @Test
    public void testBorrowReturnPool() {
        DirContext dirContext = null;
        DirContextProvider dirContextProvider = DirContextProvider.getInstance();
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            Assert.fail(ex.getMessage());
        }
        Assert.assertNotNull(dirContext);
        dirContextProvider.returnDirContext(dirContext);
        assert (dirContextProvider.getNumDirContextActive() == 0);
    }

    @Test
    public void testMultipleBorrowReturnPool() {
        ArrayList<DirContext> dirContextList = new ArrayList<DirContext>();
        DirContextProvider dirContextProvider = DirContextProvider.getInstance();
        log.debug("Active Dir Contexts: " + dirContextProvider.getNumDirContextActive());
        log.debug("Idle Dir Contexts: " + dirContextProvider.getNumDirContextIdle());
        int i = 0;
        while (i < 5) {
            try {
                dirContextList.add(dirContextProvider.borrowDirContext());
                log.debug("added dirContext #" + i);
                log.debug("After Adding: Active Dir Contexts: " + dirContextProvider.getNumDirContextActive());
                log.debug("After Adding: Idle Dir Contexts: " + dirContextProvider.getNumDirContextIdle());
                ++i;
            }
            catch (NoSuchElementException ex) {
                log.warn(ex.getMessage());
                DirContext dirContext = (DirContext)dirContextList.remove(0);
                Assert.assertNotNull(dirContext);
                dirContextProvider.returnDirContext(dirContext);
                log.debug("After Exception: Active Dir Contexts: " + dirContextProvider.getNumDirContextActive());
                log.debug("After Exception: Idle Dir Contexts: " + dirContextProvider.getNumDirContextIdle());
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), ex);
                Assert.fail(ex.getMessage());
            }
        }
        for (DirContext dirContext : dirContextList) {
            Assert.assertNotNull(dirContext);
            dirContextProvider.returnDirContext(dirContext);
            log.debug("After Returning: Active Dir Contexts: " + dirContextProvider.getNumDirContextActive());
            log.debug("After Returning: Idle Dir Contexts: " + dirContextProvider.getNumDirContextIdle());
        }
        assert (dirContextProvider.getNumDirContextActive() == 0);
    }
}

