/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.Locale;
import java.util.Map;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.noggit.JSONUtil;

public class Replica
extends ZkNodeProps {
    private final String name;
    private final String nodeName;
    private final State state;

    public Replica(String name, Map<String, Object> propMap) {
        super(propMap);
        this.name = name;
        this.nodeName = (String)propMap.get("node_name");
        if (propMap.get("state") != null) {
            this.state = State.getState((String)propMap.get("state"));
        } else {
            this.state = State.ACTIVE;
            propMap.put("state", this.state.toString());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getCoreUrl() {
        return ZkCoreNodeProps.getCoreUrl(this.getStr("base_url"), this.getStr("core"));
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public State getState() {
        return this.state;
    }

    @Override
    public String toString() {
        return this.name + ':' + JSONUtil.toJSON(this.propMap, -1);
    }

    public static enum State {
        ACTIVE,
        DOWN,
        RECOVERING,
        RECOVERY_FAILED;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public static State getState(String stateStr) {
            return stateStr == null ? null : State.valueOf(stateStr.toUpperCase(Locale.ROOT));
        }
    }
}

