/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.test.ReasonerTester;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestRDFSRules
extends TestCase {
    public static final String NAMESPACE = "http://www.hpl.hp.com/semweb/2003/query_tester/";
    protected static Log logger = LogFactory.getLog(TestRDFSRules.class);

    public TestRDFSRules(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestRDFSRules.class);
    }

    public void hiddenTestRDFSReasonerDebug() throws IOException {
        ReasonerTester tester = new ReasonerTester("rdfs/manifest-nodirect-noresource.rdf");
        ReasonerFactory rf = RDFSRuleReasonerFactory.theInstance();
        TestRDFSRules.assertTrue("RDFS hybrid-tgc reasoner test", tester.runTest("http://www.hpl.hp.com/semweb/2003/query_tester/rdfs/test11", rf, this, null));
    }

    public void testRDFSFBReasoner() throws IOException {
        ReasonerTester tester = new ReasonerTester("rdfs/manifest-nodirect-noresource.rdf");
        ReasonerFactory rf = RDFSFBRuleReasonerFactory.theInstance();
        TestRDFSRules.assertTrue("RDFS hybrid reasoner tests", tester.runTests(rf, this, null));
    }

    public void testRDFSExptReasoner() throws IOException {
        ReasonerTester tester = new ReasonerTester("rdfs/manifest-nodirect-noresource.rdf");
        ReasonerFactory rf = RDFSRuleReasonerFactory.theInstance();
        TestRDFSRules.assertTrue("RDFS experimental (hybrid+tgc) reasoner tests", tester.runTests(rf, this, null));
    }

    public void testRDFSDescription() {
        ReasonerFactory rf = RDFSFBRuleReasonerFactory.theInstance();
        Reasoner r = rf.create(null);
        TestRDFSRules.assertTrue(r.supportsProperty(RDFS.subClassOf));
        TestRDFSRules.assertTrue(r.supportsProperty(RDFS.domain));
        TestRDFSRules.assertTrue(!r.supportsProperty(OWL.allValuesFrom));
    }

    private static void doTiming(Reasoner r, Model tbox, Model data, String name, int loop) {
        Resource C1 = ResourceFactory.createResource("http://www.hpl.hp.com/semweb/2003/eg#C1");
        Resource C2 = ResourceFactory.createResource("http://www.hpl.hp.com/semweb/2003/eg#C2");
        long t1 = System.currentTimeMillis();
        int count = 0;
        for (int lp = 0; lp < loop; ++lp) {
            Model m = ModelFactory.createModelForGraph(r.bindSchema(tbox.getGraph()).bind(data.getGraph()));
            count = 0;
            StmtIterator i = m.listStatements(null, RDF.type, C1);
            while (i.hasNext()) {
                ++count;
                i.next();
            }
        }
        long t2 = System.currentTimeMillis();
        long time10 = (t2 - t1) * 10L / (long)loop;
        long time = time10 / 10L;
        long timeFraction = time10 - time * 10L;
        System.out.println(name + ": " + count + " results in " + time + "." + timeFraction + "ms");
    }

    public static void main(String[] args) {
        try {
            Model tbox = FileManager.get().loadModel("testing/reasoners/rdfs/timing-tbox.rdf");
            Model data = FileManager.get().loadModel("testing/reasoners/rdfs/timing-data.rdf");
            Reasoner rdfsFBRule = RDFSFBRuleReasonerFactory.theInstance().create(null);
            Reasoner rdfs1 = RDFSReasonerFactory.theInstance().create(null);
            Reasoner rdfsFinal = RDFSRuleReasonerFactory.theInstance().create(null);
            TestRDFSRules.doTiming(rdfs1, tbox, data, "RDFS1", 1);
            TestRDFSRules.doTiming(rdfsFBRule, tbox, data, "RDFS FB rule", 1);
            TestRDFSRules.doTiming(rdfsFinal, tbox, data, "RDFS final rule", 1);
            TestRDFSRules.doTiming(rdfs1, tbox, data, "RDFS1", 50);
            TestRDFSRules.doTiming(rdfsFBRule, tbox, data, "RDFS FB rule", 50);
            TestRDFSRules.doTiming(rdfsFinal, tbox, data, "RDFS final rule", 50);
        }
        catch (Exception e2) {
            System.out.println("Problem: " + e2.toString());
            e2.printStackTrace();
        }
    }
}

