/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.shared.PrefixMapping;
import junit.framework.TestSuite;

public class TestModelFactory
extends ModelTestBase {
    public static final Resource DAMLLangResource = TestModelFactory.resource("http://www.daml.org/2001/03/daml+oil#");

    public TestModelFactory(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelFactory.class);
    }

    public void testCreateDefaultModel() {
        ModelFactory.createDefaultModel().close();
    }

    public void testGetDefaultPrefixMapping() {
        TestModelFactory.assertSame(ModelCom.getDefaultModelPrefixes(), ModelFactory.getDefaultModelPrefixes());
    }

    public void testSetDefaultPrefixMapping() {
        PrefixMapping original = ModelCom.getDefaultModelPrefixes();
        PrefixMapping pm = PrefixMapping.Factory.create();
        ModelFactory.setDefaultModelPrefixes(pm);
        TestModelFactory.assertSame(pm, ModelCom.getDefaultModelPrefixes());
        TestModelFactory.assertSame(pm, ModelFactory.getDefaultModelPrefixes());
        ModelCom.setDefaultModelPrefixes(original);
    }

    public void testCreateInfModel() {
        String rule = "-> (eg:r eg:p eg:v).";
        GenericRuleReasoner r = new GenericRuleReasoner(Rule.parseRules(rule));
        InfGraph ig = r.bind(ModelFactory.createDefaultModel().getGraph());
        InfModel im = ModelFactory.createInfModel(ig);
        TestModelFactory.assertInstanceOf(InfModel.class, im);
        TestModelFactory.assertEquals(1L, im.size());
    }

    public void testCreateUnion() {
        Model m1 = ModelFactory.createDefaultModel();
        Model m2 = ModelFactory.createDefaultModel();
        Model m = ModelFactory.createUnion(m1, m2);
        TestModelFactory.assertInstanceOf(Union.class, m.getGraph());
        TestModelFactory.assertSame(m1.getGraph(), ((Union)m.getGraph()).getL());
        TestModelFactory.assertSame(m2.getGraph(), ((Union)m.getGraph()).getR());
    }

    public void testAssembleModelFromModel() {
    }

    public void testFindAssemblerRoots() {
    }

    public void testAssmbleModelFromRoot() {
    }
}

