/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.query.BufferPipe;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.QueryStageException;
import junit.framework.TestSuite;

public class TestBufferPipe
extends GraphTestBase {
    public TestBufferPipe(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestBufferPipe.class);
    }

    public void testEmpty() {
        BufferPipe p = new BufferPipe();
        p.close();
        TestBufferPipe.assertFalse(p.hasNext());
    }

    public void testNonEmpty() {
        BufferPipe p = new BufferPipe();
        p.put(new Domain(0));
        p.close();
        TestBufferPipe.assertTrue(p.hasNext());
        p.get();
        TestBufferPipe.assertFalse(p.hasNext());
    }

    public void testExceptions() {
        BufferPipe p = new BufferPipe();
        JenaException bang = new JenaException("bang");
        p.close(bang);
        try {
            p.get();
            TestBufferPipe.fail("bang disappeared");
        }
        catch (QueryStageException e2) {
            TestBufferPipe.pass();
        }
    }
}

