/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.ICache;
import com.hp.hpl.jena.db.impl.IDBID;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.Map;
import java.util.Random;

public class LRUCache
implements ICache {
    protected Map keyCache;
    protected Map valCache;
    protected IDBID[] Keys;
    protected Random rand = new Random();
    protected int maxCount;
    protected int count;

    public LRUCache(int max2) {
        this.resize(max2);
    }

    protected void resize(int max2) {
        this.maxCount = max2;
        this.keyCache = CollectionFactory.createHashedMap(max2);
        this.valCache = CollectionFactory.createHashedMap(max2);
        this.Keys = new IDBID[max2];
        this.count = 0;
    }

    public Object get(IDBID id) {
        return this.keyCache.get(id);
    }

    public Object getByValue(String val) {
        return this.valCache.get(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(IDBID id, Object val) {
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            int curSize = this.keyCache.size();
            this.keyCache.put(id, val);
            this.valCache.put(val, id);
            if (this.keyCache.size() > curSize) {
                int ix = this.count++;
                if (this.count > this.maxCount) {
                    ix = this.rand.nextInt(this.maxCount);
                    Object keyval = this.keyCache.get(this.Keys[ix]);
                    if (keyval == null || this.keyCache.remove(this.Keys[ix]) == null) {
                        throw new JenaException("LRUCache keyCache corrupted");
                    }
                    if (this.valCache.remove(keyval) == null) {
                        throw new JenaException("LRUCache valCache corrupted");
                    }
                    --this.count;
                    this.Keys[ix] = id;
                    if (this.keyCache.size() > this.maxCount) {
                        throw new JenaException("LRUCache exceeds threshold");
                    }
                }
                this.Keys[ix] = id;
            }
        }
    }

    public void clear() {
        this.keyCache.clear();
        this.valCache.clear();
        this.count = 0;
    }

    public void setLimit(int max2) {
        this.resize(max2);
    }

    public int getLimit() {
        return this.maxCount;
    }
}

