/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.BadObjectException;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.FileModelAssembler;
import com.hp.hpl.jena.assembler.test.ModelAssemblerTestBase;
import com.hp.hpl.jena.graph.impl.FileGraph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.FileUtils;
import java.io.File;
import junit.framework.Assert;

public class TestFileModelAssembler
extends ModelAssemblerTestBase {
    public TestFileModelAssembler(String name) {
        super(name);
    }

    protected Class getAssemblerClass() {
        return FileModelAssembler.class;
    }

    public void testFileModelAssemblerType() {
        this.testDemandsMinimalType(new FileModelAssembler(), JA.FileModel);
    }

    public void testFileAssemblerExists() {
        TestFileModelAssembler.assertInstanceOf(Assembler.class, Assembler.fileModel);
        TestFileModelAssembler.assertInstanceOf(FileModelAssembler.class, Assembler.fileModel);
    }

    public void testFileAssemblerVocabulary() {
        this.assertSubclassOf(JA.FileModel, JA.NamedModel);
        this.assertDomain(JA.FileModel, JA.fileEncoding);
        this.assertDomain(JA.FileModel, JA.directory);
        this.assertDomain(JA.FileModel, JA.mapName);
    }

    public void testFileModelAssemblerCreatesFileModels() {
        FileModelAssembler a = new FileModelAssembler();
        File x = FileUtils.tempFileName("fileModelAssembler", ".n3");
        Model m = a.createFileModel(x, "N3", true, false, ReificationStyle.Convenient);
        TestFileModelAssembler.assertInstanceOf(FileGraph.class, m.getGraph());
        FileGraph fg = (FileGraph)m.getGraph();
        TestFileModelAssembler.assertEquals(x, fg.name);
        TestFileModelAssembler.assertSame(ReificationStyle.Convenient, fg.getReifier().getStyle());
    }

    public void testFileModelAssemblerUsesSpecialisedMethod() {
        final Model model = ModelFactory.createDefaultModel();
        FileModelAssembler a = new FileModelAssembler(){

            public Model createFileModel(File fullName, String lang, boolean create, boolean strict, ReificationStyle style) {
                return model;
            }
        };
        Resource root = this.resourceInModel("x rdf:type ja:FileModel; x ja:modelName 'junk'; x ja:directory file:");
        Model m = a.openModel(root);
        TestFileModelAssembler.assertSame(model, m);
    }

    public void testFileModelAssemblerUsesLanguage() {
        final Model model = ModelFactory.createDefaultModel();
        Resource root = this.resourceInModel("x rdf:type ja:FileModel; x ja:modelName 'junk'; x ja:directory file:; x ja:fileEncoding 'LANG'");
        FileModelAssembler a = new FileModelAssembler(){

            public Model createFileModel(File fullName, String lang, boolean create, boolean strict, ReificationStyle style) {
                Assert.assertEquals("LANG", lang);
                return model;
            }
        };
        Model m = a.openModel(root);
        TestFileModelAssembler.assertSame(model, m);
    }

    public void testFileModelAssemblerTrapsBadLanguage() {
        this.testTrapsBadLanguage("badLanguage");
        this.testTrapsBadLanguage("17");
        this.testTrapsBadLanguage("'invalid'xsd:rhubarb");
    }

    private void testTrapsBadLanguage(String lang) {
        final Model model = ModelFactory.createDefaultModel();
        Resource root = this.resourceInModel("x rdf:type ja:FileModel; x ja:modelName 'junk'; x ja:directory file:; x ja:fileEncoding <lang>".replaceAll("<lang>", lang));
        FileModelAssembler a = new FileModelAssembler(){

            public Model createFileModel(File fullName, String lang, boolean create, boolean strict, ReificationStyle style) {
                return model;
            }
        };
        try {
            a.openModel(root);
            TestFileModelAssembler.fail("should trap bad fileEncoding object");
        }
        catch (BadObjectException e2) {
            Model m = e2.getRoot().getModel();
            TestFileModelAssembler.assertEquals(TestFileModelAssembler.resource("x"), e2.getRoot());
            TestFileModelAssembler.assertEquals(TestFileModelAssembler.rdfNode(m, lang), e2.getObject());
        }
    }

    public void testFileModelAssemblerUsesStyle() {
        this.testUsesStyle("ja:minimal", ReificationStyle.Minimal);
        this.testUsesStyle("ja:standard", ReificationStyle.Standard);
        this.testUsesStyle("ja:convenient", ReificationStyle.Convenient);
    }

    private void testUsesStyle(String styleString, final ReificationStyle style) {
        final Model model = ModelFactory.createDefaultModel();
        FileModelAssembler a = new FileModelAssembler(){

            public Model createFileModel(File fullName, String lang, boolean create, boolean strict, ReificationStyle s) {
                Assert.assertSame(style, s);
                return model;
            }
        };
        Resource root = this.resourceInModel("x rdf:type ja:FileModel; x ja:modelName 'junk'; x ja:directory file:; x ja:reificationMode " + styleString);
        Model m = a.openModel(root);
        TestFileModelAssembler.assertSame(model, m);
    }

    public void testFileModelAssemblerUsesMode() {
        this.testMode(true, true);
        this.testMode(false, true);
        this.testMode(true, false);
        try {
            this.testMode(false, false);
            TestFileModelAssembler.fail("should trap, can nver create");
        }
        catch (JenaException e2) {
            TestFileModelAssembler.pass();
        }
    }

    private void testMode(final boolean mayCreate, final boolean mayReuse) {
        final Model model = ModelFactory.createDefaultModel();
        Mode mode = new Mode(mayCreate, mayReuse);
        FileModelAssembler a = new FileModelAssembler(){

            public Model createFileModel(File fullName, String lang, boolean create, boolean strict, ReificationStyle s) {
                if (mayCreate && mayReuse) {
                    Assert.assertEquals("mayCreate && mayReuse implies non-strict", false, strict);
                }
                if (mayCreate && !mayReuse) {
                    Assert.assertEquals(true, create);
                    Assert.assertEquals(true, strict);
                }
                if (!mayCreate && mayReuse) {
                    Assert.assertEquals(false, create);
                    Assert.assertEquals(true, strict);
                }
                if (!mayCreate && !mayReuse) {
                    throw new JenaException("cannot create");
                }
                return model;
            }
        };
        Resource root = this.resourceInModel("x rdf:type ja:FileModel; x ja:modelName 'junk'; x ja:directory file:");
        Model m = a.openModel(root, mode);
        TestFileModelAssembler.assertSame(model, m);
    }

    public void testCorrectSimpleModelName() {
        this.testCorrectModelName("root/spoo", "root", "spoo", empty);
        this.testCorrectModelName("root/branch/spoo", "root/branch", "spoo", empty);
        this.testCorrectModelName("/root/spoo", "/root", "spoo", empty);
        this.testCorrectModelName("root/spoo", "root", "spoo", empty);
    }

    public void testCorrectURIModelName() {
        this.testCorrectModelName("root/name/subname", "root", "name/subname", empty);
        this.testCorrectModelName("root/name_Ssubname", "root", "name/subname", this.model("x ja:mapName ja:true"));
        this.testCorrectModelName("root/name_Usubname", "root", "name_subname", this.model("x ja:mapName ja:true"));
        this.testCorrectModelName("root/name_Csubname", "root", "name:subname", this.model("x ja:mapName ja:true"));
        this.testCorrectModelName("root/http_C_S_Sdomain_Sdir_Sname", "root", "http://domain/dir/name", this.model("x ja:mapName ja:true"));
    }

    private void testCorrectModelName(String expectedName, String directoryName, String modelName, Model extras) {
        final Model model = ModelFactory.createDefaultModel();
        final File wantedFullName = new File(expectedName);
        final ReificationStyle wantedStyle = ReificationStyle.Standard;
        final boolean wantedCreate = Mode.DEFAULT.permitCreateNew(null, null);
        final boolean wantedStrict = Mode.DEFAULT.permitUseExisting(null, null);
        Resource root = this.resourceInModel("x rdf:type ja:FileModel; x ja:modelName '" + modelName + "'; x ja:directory file:" + directoryName);
        root.getModel().add(extras);
        FileModelAssembler a = new FileModelAssembler(){

            public Model createFileModel(File fullName, String lang, boolean create, boolean strict, ReificationStyle style) {
                Assert.assertEquals(wantedFullName, fullName);
                Assert.assertEquals(wantedStyle, style);
                Assert.assertEquals(wantedCreate, create);
                Assert.assertEquals(wantedStrict, strict);
                return model;
            }
        };
        Model m = a.openModel(root);
        TestFileModelAssembler.assertSame(model, m);
    }
}

