/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.util.Clock;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final Object notEmptyLock = new Object();
    private final Queue<E> priorityQueue = new ConcurrentLinkedQueue();
    private final Queue<E> defaultQueue = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e2) throws InterruptedException {
        this.defaultQueue.offer(e2);
        Object object = this.notEmptyLock;
        synchronized (object) {
            this.notEmptyLock.notify();
        }
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E e2, long timeout, TimeUnit unit) throws InterruptedException {
        this.put(e2);
        return true;
    }

    @Override
    public int size() {
        return this.priorityQueue.size() + this.defaultQueue.size();
    }

    @Override
    public E take() throws InterruptedException {
        return this.poll(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        long start;
        long now2;
        E e2 = this.tryPoll();
        if (e2 != null) {
            return e2;
        }
        for (long timeLeft = unit.toMillis(timeout); e2 == null && timeLeft > 0L; timeLeft -= now2 - start) {
            start = Clock.currentTimeMillis();
            Object object = this.notEmptyLock;
            synchronized (object) {
                this.notEmptyLock.wait(100L);
            }
            e2 = this.tryPoll();
            now2 = Clock.currentTimeMillis();
            start = now2;
        }
        return e2;
    }

    E tryPoll() {
        E e2 = this.priorityQueue.poll();
        if (e2 == null) {
            e2 = this.defaultQueue.poll();
        }
        return e2;
    }

    @Override
    public E poll() {
        return this.tryPoll();
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E e2) {
        return this.defaultQueue.offer(e2);
    }

    @Override
    public E peek() {
        throw new UnsupportedOperationException();
    }
}

