/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import javax.sql.DataSource;
import junit.framework.AssertionFailedError;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.test.AbstractTransactionalDataSourceSpringContextTests;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.annotation.ExpectedException;
import org.springframework.test.annotation.NotTransactional;
import org.springframework.test.annotation.ProfileValueSource;
import org.springframework.test.annotation.ProfileValueUtils;
import org.springframework.test.annotation.Repeat;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.annotation.Timed;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.Assert;

@Deprecated
public abstract class AbstractAnnotationAwareTransactionalTests
extends AbstractTransactionalDataSourceSpringContextTests {
    protected SimpleJdbcTemplate simpleJdbcTemplate;
    private final TransactionAttributeSource transactionAttributeSource = new AnnotationTransactionAttributeSource();
    protected ProfileValueSource profileValueSource = ProfileValueUtils.retrieveProfileValueSource(this.getClass());

    public AbstractAnnotationAwareTransactionalTests() {
        this(null);
    }

    public AbstractAnnotationAwareTransactionalTests(String name) {
        super(name);
    }

    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(this.jdbcTemplate);
    }

    @Deprecated
    protected void findUniqueProfileValueSourceFromContext(ApplicationContext applicationContext) {
        Assert.notNull(applicationContext, "Can not search for a ProfileValueSource in a null ApplicationContext.");
        ProfileValueSource uniqueProfileValueSource = null;
        Map<String, ProfileValueSource> beans = applicationContext.getBeansOfType(ProfileValueSource.class);
        if (beans.size() == 1) {
            uniqueProfileValueSource = beans.values().iterator().next();
        }
        if (uniqueProfileValueSource != null) {
            this.profileValueSource = uniqueProfileValueSource;
        }
    }

    public void runBare() throws Throwable {
        if (this.isDisabledInThisEnvironment(this.getName())) {
            super.runBare();
            return;
        }
        final Method testMethod = this.getTestMethod();
        if (this.isDisabledInThisEnvironment(testMethod)) {
            this.recordDisabled();
            this.logger.info("**** " + this.getClass().getName() + "." + this.getName() + " is disabled in this environment: " + "Total disabled tests=" + AbstractAnnotationAwareTransactionalTests.getDisabledTestCount());
            return;
        }
        TransactionAttribute explicitTransactionDefinition = this.transactionAttributeSource.getTransactionAttribute(testMethod, this.getClass());
        if (explicitTransactionDefinition != null) {
            this.logger.info("Custom transaction definition [" + explicitTransactionDefinition + "] for test method [" + this.getName() + "].");
            this.setTransactionDefinition(explicitTransactionDefinition);
        } else if (testMethod.isAnnotationPresent(NotTransactional.class)) {
            this.preventTransaction();
        }
        this.runTestTimed(new TestExecutionCallback(){

            public void run() throws Throwable {
                try {
                    AbstractAnnotationAwareTransactionalTests.super.runBare();
                }
                finally {
                    if (testMethod.isAnnotationPresent(DirtiesContext.class)) {
                        AbstractAnnotationAwareTransactionalTests.this.setDirty();
                    }
                }
            }
        }, testMethod);
    }

    protected boolean isDisabledInThisEnvironment(Method testMethod) {
        return !ProfileValueUtils.isTestEnabledInThisEnvironment(this.profileValueSource, testMethod, this.getClass());
    }

    protected Method getTestMethod() {
        AbstractAnnotationAwareTransactionalTests.assertNotNull("TestCase.getName() cannot be null", this.getName());
        Method testMethod = null;
        try {
            testMethod = this.getClass().getMethod(this.getName(), null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            AbstractAnnotationAwareTransactionalTests.fail("Method '" + this.getName() + "' not found");
        }
        if (!Modifier.isPublic(testMethod.getModifiers())) {
            AbstractAnnotationAwareTransactionalTests.fail("Method '" + this.getName() + "' should be public");
        }
        return testMethod;
    }

    protected boolean isRollback() {
        boolean rollback = this.isDefaultRollback();
        Rollback rollbackAnnotation = this.getTestMethod().getAnnotation(Rollback.class);
        if (rollbackAnnotation != null) {
            boolean rollbackOverride = rollbackAnnotation.value();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Method-level @Rollback(" + rollbackOverride + ") overrides default rollback [" + rollback + "] for test [" + this.getName() + "].");
            }
            rollback = rollbackOverride;
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("No method-level @Rollback override: using default rollback [" + rollback + "] for test [" + this.getName() + "].");
        }
        return rollback;
    }

    private void runTestTimed(TestExecutionCallback tec, Method testMethod) throws Throwable {
        Timed timed = testMethod.getAnnotation(Timed.class);
        if (timed == null) {
            this.runTest(tec, testMethod);
        } else {
            long startTime = System.currentTimeMillis();
            try {
                this.runTest(tec, testMethod);
            }
            finally {
                long elapsed = System.currentTimeMillis() - startTime;
                if (elapsed > timed.millis()) {
                    AbstractAnnotationAwareTransactionalTests.fail("Took " + elapsed + " ms; limit was " + timed.millis());
                }
            }
        }
    }

    private void runTest(TestExecutionCallback tec, Method testMethod) throws Throwable {
        ExpectedException expectedExceptionAnnotation = testMethod.getAnnotation(ExpectedException.class);
        boolean exceptionIsExpected = expectedExceptionAnnotation != null && expectedExceptionAnnotation.value() != null;
        Class<? extends Throwable> expectedException = exceptionIsExpected ? expectedExceptionAnnotation.value() : null;
        Repeat repeat = testMethod.getAnnotation(Repeat.class);
        int runs = repeat != null && repeat.value() > 1 ? repeat.value() : 1;
        int i = 0;
        while (i < runs) {
            block6: {
                try {
                    if (runs > 1 && this.logger != null && this.logger.isInfoEnabled()) {
                        this.logger.info("Repetition " + (i + 1) + " of test " + testMethod.getName());
                    }
                    tec.run();
                    if (exceptionIsExpected) {
                        AbstractAnnotationAwareTransactionalTests.fail("Expected exception: " + expectedException.getName());
                    }
                }
                catch (Throwable t) {
                    if (!exceptionIsExpected) {
                        throw t;
                    }
                    if (expectedException.isAssignableFrom(t.getClass())) break block6;
                    AssertionFailedError assertionError = new AssertionFailedError("Unexpected exception, expected<" + expectedException.getName() + "> but was<" + t.getClass().getName() + ">");
                    assertionError.initCause(t);
                    throw assertionError;
                }
            }
            ++i;
        }
    }

    private static interface TestExecutionCallback {
        public void run() throws Throwable;
    }
}

