/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.spi.ClassLoadHelper;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scheduling.quartz.JobDetailAwareTrigger;
import org.springframework.scheduling.quartz.ResourceLoaderClassLoadHelper;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SchedulerAccessor
implements ResourceLoaderAware {
    private static Class<?> jobKeyClass;
    private static Class<?> triggerKeyClass;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean overwriteExistingJobs = false;
    private String[] jobSchedulingDataLocations;
    private List<JobDetail> jobDetails;
    private Map<String, Calendar> calendars;
    private List<Trigger> triggers;
    private SchedulerListener[] schedulerListeners;
    private JobListener[] globalJobListeners;
    private JobListener[] jobListeners;
    private TriggerListener[] globalTriggerListeners;
    private TriggerListener[] triggerListeners;
    private PlatformTransactionManager transactionManager;
    protected ResourceLoader resourceLoader;

    static {
        try {
            jobKeyClass = Class.forName("org.quartz.JobKey");
            triggerKeyClass = Class.forName("org.quartz.TriggerKey");
        }
        catch (ClassNotFoundException classNotFoundException) {
            jobKeyClass = null;
            triggerKeyClass = null;
        }
    }

    public void setOverwriteExistingJobs(boolean overwriteExistingJobs) {
        this.overwriteExistingJobs = overwriteExistingJobs;
    }

    public void setJobSchedulingDataLocation(String jobSchedulingDataLocation) {
        this.jobSchedulingDataLocations = new String[]{jobSchedulingDataLocation};
    }

    public void setJobSchedulingDataLocations(String[] jobSchedulingDataLocations) {
        this.jobSchedulingDataLocations = jobSchedulingDataLocations;
    }

    public void setJobDetails(JobDetail[] jobDetails) {
        this.jobDetails = new ArrayList<JobDetail>((Collection)Arrays.asList(jobDetails));
    }

    public void setCalendars(Map<String, Calendar> calendars) {
        this.calendars = calendars;
    }

    public void setTriggers(Trigger[] triggers) {
        this.triggers = Arrays.asList(triggers);
    }

    public void setSchedulerListeners(SchedulerListener[] schedulerListeners) {
        this.schedulerListeners = schedulerListeners;
    }

    public void setGlobalJobListeners(JobListener[] globalJobListeners) {
        this.globalJobListeners = globalJobListeners;
    }

    public void setJobListeners(JobListener[] jobListeners) {
        this.jobListeners = jobListeners;
    }

    public void setGlobalTriggerListeners(TriggerListener[] globalTriggerListeners) {
        this.globalTriggerListeners = globalTriggerListeners;
    }

    public void setTriggerListeners(TriggerListener[] triggerListeners) {
        this.triggerListeners = triggerListeners;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    /*
     * Unable to fully structure code
     */
    protected void registerJobsAndTriggers() throws SchedulerException {
        transactionStatus = null;
        if (this.transactionManager != null) {
            transactionStatus = this.transactionManager.getTransaction(new DefaultTransactionDefinition());
        }
        try {
            block21: {
                if (this.jobSchedulingDataLocations != null) {
                    clh = new ResourceLoaderClassLoadHelper(this.resourceLoader);
                    clh.initialize();
                    try {
                        dataProcessorClass = this.getClass().getClassLoader().loadClass("org.quartz.xml.XMLSchedulingDataProcessor");
                        this.logger.debug("Using Quartz 1.8 XMLSchedulingDataProcessor");
                        dataProcessor = dataProcessorClass.getConstructor(new Class[]{ClassLoadHelper.class}).newInstance(new Object[]{clh});
                        processFileAndScheduleJobs = dataProcessorClass.getMethod("processFileAndScheduleJobs", new Class[]{String.class, Scheduler.class});
                        var9_8 = this.jobSchedulingDataLocations;
                        var8_9 = this.jobSchedulingDataLocations.length;
                        var7_10 = 0;
                        while (var7_10 < var8_9) {
                            location = var9_8[var7_10];
                            processFileAndScheduleJobs.invoke(dataProcessor, new Object[]{location, this.getScheduler()});
                            ++var7_10;
                        }
                        break block21;
                    }
                    catch (ClassNotFoundException v0) {
                        dataProcessorClass = this.getClass().getClassLoader().loadClass("org.quartz.xml.JobSchedulingDataProcessor");
                        this.logger.debug("Using Quartz 1.6 JobSchedulingDataProcessor");
                        dataProcessor = dataProcessorClass.getConstructor(new Class[]{ClassLoadHelper.class, Boolean.TYPE, Boolean.TYPE}).newInstance(new Object[]{clh, true, true});
                        processFileAndScheduleJobs = dataProcessorClass.getMethod("processFileAndScheduleJobs", new Class[]{String.class, Scheduler.class, Boolean.TYPE});
                        var9_8 = this.jobSchedulingDataLocations;
                        var8_9 = this.jobSchedulingDataLocations.length;
                        var7_10 = 0;
                        ** while (var7_10 < var8_9)
                    }
lbl-1000:
                    // 1 sources

                    {
                        location = var9_8[var7_10];
                        processFileAndScheduleJobs.invoke(dataProcessor, new Object[]{location, this.getScheduler(), this.overwriteExistingJobs});
                        ++var7_10;
                        continue;
                    }
                }
            }
            if (this.jobDetails != null) {
                for (JobDetail jobDetail : this.jobDetails) {
                    this.addJobToScheduler(jobDetail);
                }
            } else {
                this.jobDetails = new LinkedList<JobDetail>();
            }
            if (this.calendars != null) {
                for (String calendarName : this.calendars.keySet()) {
                    calendar = this.calendars.get(calendarName);
                    this.getScheduler().addCalendar(calendarName, calendar, true, true);
                }
            }
            if (this.triggers != null) {
                for (Trigger trigger : this.triggers) {
                    this.addTriggerToScheduler(trigger);
                }
            }
        }
        catch (Throwable ex) {
            if (transactionStatus != null) {
                try {
                    this.transactionManager.rollback(transactionStatus);
                }
                catch (TransactionException tex) {
                    this.logger.error("Job registration exception overridden by rollback exception", ex);
                    throw tex;
                }
            }
            if (ex instanceof SchedulerException) {
                throw (SchedulerException)ex;
            }
            if (ex instanceof Exception) {
                throw new SchedulerException("Registration of jobs and triggers failed: " + ex.getMessage(), ex);
            }
            throw new SchedulerException("Registration of jobs and triggers failed: " + ex.getMessage());
        }
        if (transactionStatus != null) {
            this.transactionManager.commit(transactionStatus);
        }
    }

    private boolean addJobToScheduler(JobDetail jobDetail) throws SchedulerException {
        if (this.overwriteExistingJobs || !this.jobDetailExists(jobDetail)) {
            this.getScheduler().addJob(jobDetail, true);
            return true;
        }
        return false;
    }

    private boolean addTriggerToScheduler(Trigger trigger) throws SchedulerException {
        boolean triggerExists = this.triggerExists(trigger);
        if (!triggerExists || this.overwriteExistingJobs) {
            JobDetail jobDetail = this.findJobDetail(trigger);
            if (jobDetail != null && !this.jobDetails.contains(jobDetail) && this.addJobToScheduler(jobDetail)) {
                this.jobDetails.add(jobDetail);
            }
            if (!triggerExists) {
                try {
                    this.getScheduler().scheduleJob(trigger);
                }
                catch (ObjectAlreadyExistsException ex) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Unexpectedly found existing trigger, assumably due to cluster race condition: " + ex.getMessage() + " - can safely be ignored");
                    }
                    if (this.overwriteExistingJobs) {
                        this.rescheduleJob(trigger);
                    }
                }
            } else {
                this.rescheduleJob(trigger);
            }
            return true;
        }
        return false;
    }

    private JobDetail findJobDetail(Trigger trigger) {
        if (trigger instanceof JobDetailAwareTrigger) {
            return ((JobDetailAwareTrigger)trigger).getJobDetail();
        }
        try {
            Map jobDataMap = (Map)ReflectionUtils.invokeMethod(Trigger.class.getMethod("getJobDataMap", new Class[0]), trigger);
            return (JobDetail)jobDataMap.get("jobDetail");
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Inconsistent Quartz API: " + ex);
        }
    }

    private boolean jobDetailExists(JobDetail jobDetail) throws SchedulerException {
        if (jobKeyClass != null) {
            try {
                Method getJobDetail = Scheduler.class.getMethod("getJobDetail", jobKeyClass);
                Object key = ReflectionUtils.invokeMethod(JobDetail.class.getMethod("getKey", new Class[0]), jobDetail);
                return ReflectionUtils.invokeMethod(getJobDetail, this.getScheduler(), key) != null;
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Inconsistent Quartz 2.0 API: " + ex);
            }
        }
        return this.getScheduler().getJobDetail(jobDetail.getName(), jobDetail.getGroup()) != null;
    }

    private boolean triggerExists(Trigger trigger) throws SchedulerException {
        if (triggerKeyClass != null) {
            try {
                Method getTrigger = Scheduler.class.getMethod("getTrigger", triggerKeyClass);
                Object key = ReflectionUtils.invokeMethod(Trigger.class.getMethod("getKey", new Class[0]), trigger);
                return ReflectionUtils.invokeMethod(getTrigger, this.getScheduler(), key) != null;
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Inconsistent Quartz 2.0 API: " + ex);
            }
        }
        return this.getScheduler().getTrigger(trigger.getName(), trigger.getGroup()) != null;
    }

    private void rescheduleJob(Trigger trigger) throws SchedulerException {
        if (triggerKeyClass != null) {
            try {
                Method rescheduleJob = Scheduler.class.getMethod("rescheduleJob", triggerKeyClass, Trigger.class);
                Object key = ReflectionUtils.invokeMethod(Trigger.class.getMethod("getKey", new Class[0]), trigger);
                ReflectionUtils.invokeMethod(rescheduleJob, this.getScheduler(), key, trigger);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Inconsistent Quartz 2.0 API: " + ex);
            }
        } else {
            this.getScheduler().rescheduleJob(trigger.getName(), trigger.getGroup(), trigger);
        }
    }

    protected void registerListeners() throws SchedulerException {
        boolean quartz2;
        Object target;
        try {
            Method getListenerManager = Scheduler.class.getMethod("getListenerManager", new Class[0]);
            target = ReflectionUtils.invokeMethod(getListenerManager, this.getScheduler());
            quartz2 = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            target = this.getScheduler();
            quartz2 = false;
        }
        try {
            JobListener listener;
            SchedulerListener listener2;
            int n;
            int n2;
            SchedulerListener[] schedulerListenerArray;
            if (this.schedulerListeners != null) {
                Method addSchedulerListener = target.getClass().getMethod("addSchedulerListener", SchedulerListener.class);
                schedulerListenerArray = this.schedulerListeners;
                n2 = this.schedulerListeners.length;
                n = 0;
                while (n < n2) {
                    listener2 = schedulerListenerArray[n];
                    ReflectionUtils.invokeMethod(addSchedulerListener, target, listener2);
                    ++n;
                }
            }
            if (this.globalJobListeners != null) {
                Method addJobListener = target.getClass().getMethod(quartz2 ? "addJobListener" : "addGlobalJobListener", JobListener.class);
                schedulerListenerArray = this.globalJobListeners;
                n2 = this.globalJobListeners.length;
                n = 0;
                while (n < n2) {
                    listener2 = schedulerListenerArray[n];
                    ReflectionUtils.invokeMethod(addJobListener, target, listener2);
                    ++n;
                }
            }
            if (this.jobListeners != null) {
                JobListener[] jobListenerArray = this.jobListeners;
                n = this.jobListeners.length;
                int listener3 = 0;
                while (listener3 < n) {
                    listener = jobListenerArray[listener3];
                    if (quartz2) {
                        throw new IllegalStateException("Non-global JobListeners not supported on Quartz 2 - manually register a Matcher against the Quartz ListenerManager instead");
                    }
                    this.getScheduler().addJobListener(listener);
                    ++listener3;
                }
            }
            if (this.globalTriggerListeners != null) {
                Method addTriggerListener = target.getClass().getMethod(quartz2 ? "addTriggerListener" : "addGlobalTriggerListener", TriggerListener.class);
                schedulerListenerArray = this.globalTriggerListeners;
                int n4 = this.globalTriggerListeners.length;
                n = 0;
                while (n < n4) {
                    SchedulerListener listener4 = schedulerListenerArray[n];
                    ReflectionUtils.invokeMethod(addTriggerListener, target, listener4);
                    ++n;
                }
            }
            if (this.triggerListeners != null) {
                TriggerListener[] triggerListenerArray = this.triggerListeners;
                n = this.triggerListeners.length;
                int n5 = 0;
                while (n5 < n) {
                    listener = triggerListenerArray[n5];
                    if (quartz2) {
                        throw new IllegalStateException("Non-global TriggerListeners not supported on Quartz 2 - manually register a Matcher against the Quartz ListenerManager instead");
                    }
                    this.getScheduler().addTriggerListener((TriggerListener)listener);
                    ++n5;
                }
            }
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Expected Quartz API not present: " + ex);
        }
    }

    protected abstract Scheduler getScheduler();
}

