/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.persistenceunit;

import javax.persistence.spi.ClassTransformer;
import org.springframework.core.DecoratingClassLoader;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import org.springframework.orm.jpa.persistenceunit.ClassFileTransformerAdapter;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class SpringPersistenceUnitInfo
extends MutablePersistenceUnitInfo {
    private static final String DEFAULT_SHARED_CACHE_MODE_NAME = "UNSPECIFIED";
    private static final String DEFAULT_VALIDATION_MODE_NAME = "AUTO";
    private String sharedCacheModeName = "UNSPECIFIED";
    private String validationModeName = "AUTO";
    private LoadTimeWeaver loadTimeWeaver;
    private ClassLoader classLoader;

    SpringPersistenceUnitInfo() {
    }

    public void setSharedCacheModeName(String sharedCacheModeName) {
        this.sharedCacheModeName = StringUtils.hasLength(sharedCacheModeName) ? sharedCacheModeName : DEFAULT_SHARED_CACHE_MODE_NAME;
    }

    public String getSharedCacheModeName() {
        return this.sharedCacheModeName;
    }

    public void setValidationModeName(String validationModeName) {
        this.validationModeName = StringUtils.hasLength(validationModeName) ? validationModeName : DEFAULT_VALIDATION_MODE_NAME;
    }

    public String getValidationModeName() {
        return this.validationModeName;
    }

    public void init(LoadTimeWeaver loadTimeWeaver) {
        Assert.notNull(loadTimeWeaver, "LoadTimeWeaver must not be null");
        this.loadTimeWeaver = loadTimeWeaver;
        this.classLoader = loadTimeWeaver.getInstrumentableClassLoader();
    }

    public void init(ClassLoader classLoader) {
        Assert.notNull(classLoader, "ClassLoader must not be null");
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void addTransformer(ClassTransformer classTransformer) {
        if (this.loadTimeWeaver == null) {
            throw new IllegalStateException("Cannot apply class transformer without LoadTimeWeaver specified");
        }
        this.loadTimeWeaver.addTransformer(new ClassFileTransformerAdapter(classTransformer));
    }

    public ClassLoader getNewTempClassLoader() {
        ClassLoader tcl = this.loadTimeWeaver != null ? this.loadTimeWeaver.getThrowawayClassLoader() : new SimpleThrowawayClassLoader(this.classLoader);
        String packageToExclude = this.getPersistenceProviderPackageName();
        if (packageToExclude != null && tcl instanceof DecoratingClassLoader) {
            ((DecoratingClassLoader)tcl).excludePackage(packageToExclude);
        }
        return tcl;
    }
}

