/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.jdo.JDOException;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.jdo.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.jdo.JdoDialect;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class DefaultJdoDialect
implements JdoDialect,
PersistenceExceptionTranslator {
    private static final Method setTimeoutMillisMethod = ClassUtils.getMethodIfAvailable(Query.class, "setTimeoutMillis", Integer.class);
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SQLExceptionTranslator jdbcExceptionTranslator;

    public DefaultJdoDialect() {
    }

    public DefaultJdoDialect(Object connectionFactory) {
        this.jdbcExceptionTranslator = PersistenceManagerFactoryUtils.newJdbcExceptionTranslator(connectionFactory);
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        return this.jdbcExceptionTranslator;
    }

    public Object beginTransaction(Transaction transaction, TransactionDefinition definition) throws JDOException, SQLException, TransactionException {
        if (definition.getIsolationLevel() != -1) {
            throw new InvalidIsolationLevelException("Standard JDO does not support custom isolation levels: use a special JdoDialect implementation for your JDO provider");
        }
        transaction.begin();
        return null;
    }

    public void cleanupTransaction(Object transactionData) {
    }

    public ConnectionHandle getJdbcConnection(PersistenceManager pm, boolean readOnly) throws JDOException, SQLException {
        return new DataStoreConnectionHandle(pm);
    }

    public void releaseJdbcConnection(ConnectionHandle conHandle, PersistenceManager pm) throws JDOException, SQLException {
    }

    public void applyQueryTimeout(Query query2, int remainingTimeInSeconds) throws JDOException {
        if (setTimeoutMillisMethod != null) {
            ReflectionUtils.invokeMethod(setTimeoutMillisMethod, query2, remainingTimeInSeconds);
        } else {
            query2.addExtension("javax.persistence.lock.timeout", (Object)remainingTimeInSeconds);
            query2.addExtension("javax.persistence.query.timeout", (Object)remainingTimeInSeconds);
        }
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof JDOException) {
            return this.translateException((JDOException)ex);
        }
        return null;
    }

    public DataAccessException translateException(JDOException ex) {
        if (this.getJdbcExceptionTranslator() != null && ex.getCause() instanceof SQLException) {
            return this.getJdbcExceptionTranslator().translate("JDO operation: " + ex.getMessage(), this.extractSqlStringFromException(ex), (SQLException)ex.getCause());
        }
        return PersistenceManagerFactoryUtils.convertJdoAccessException(ex);
    }

    protected String extractSqlStringFromException(JDOException ex) {
        return null;
    }

    private static class DataStoreConnectionHandle
    implements ConnectionHandle {
        private final PersistenceManager persistenceManager;

        public DataStoreConnectionHandle(PersistenceManager persistenceManager) {
            this.persistenceManager = persistenceManager;
        }

        public Connection getConnection() {
            return (Connection)this.persistenceManager.getDataStoreConnection();
        }

        public void releaseConnection(Connection con) {
            JdbcUtils.closeConnection(con);
        }
    }
}

