/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.util.Assert;

public class PassThroughFilterChain
implements FilterChain {
    private Filter filter;
    private FilterChain nextFilterChain;
    private Servlet servlet;

    public PassThroughFilterChain(Filter filter, FilterChain nextFilterChain) {
        Assert.notNull(filter, "Filter must not be null");
        Assert.notNull(nextFilterChain, "'FilterChain must not be null");
        this.filter = filter;
        this.nextFilterChain = nextFilterChain;
    }

    public PassThroughFilterChain(Servlet servlet) {
        Assert.notNull(servlet, "Servlet must not be null");
        this.servlet = servlet;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (this.filter != null) {
            this.filter.doFilter(request, response, this.nextFilterChain);
        } else {
            this.servlet.service(request, response);
        }
    }
}

