/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class DefaultCrudMethods
implements CrudMethods {
    private static final String FIND_ONE = "findOne";
    private static final String SAVE = "save";
    private static final String FIND_ALL = "findAll";
    private static final String DELETE = "delete";
    private final Method findAllMethod;
    private final Method findOneMethod;
    private final Method saveMethod;
    private final Method deleteMethod;

    public DefaultCrudMethods(RepositoryInformation information) {
        Assert.notNull(information, "RepositoryInformation must not be null!");
        this.findOneMethod = this.selectMostSuitableFindOneMethod(information);
        this.findAllMethod = this.selectMostSuitableFindAllMethod(information);
        this.deleteMethod = this.selectMostSuitableDeleteMethod(information);
        this.saveMethod = this.selectMostSuitableSaveMethod(information);
    }

    private Method selectMostSuitableSaveMethod(RepositoryInformation information) {
        for (Class type : Arrays.asList(information.getDomainType(), Object.class)) {
            Method saveMethodCandidate = ReflectionUtils.findMethod(information.getRepositoryInterface(), SAVE, type);
            if (saveMethodCandidate == null) continue;
            return ClassUtils.getMostSpecificMethod(saveMethodCandidate, information.getRepositoryInterface());
        }
        return null;
    }

    private Method selectMostSuitableDeleteMethod(RepositoryInformation information) {
        for (Class type : Arrays.asList(information.getIdType(), Serializable.class, Iterable.class)) {
            Method candidate = ReflectionUtils.findMethod(information.getRepositoryInterface(), DELETE, type);
            if (candidate == null) continue;
            return ClassUtils.getMostSpecificMethod(candidate, information.getRepositoryInterface());
        }
        return null;
    }

    private Method selectMostSuitableFindAllMethod(RepositoryInformation information) {
        for (Class type : Arrays.asList(Pageable.class, Sort.class)) {
            Method candidate;
            if (!ClassUtils.hasMethod(information.getRepositoryInterface(), FIND_ALL, type) || (candidate = ReflectionUtils.findMethod(PagingAndSortingRepository.class, FIND_ALL, type)) == null) continue;
            return ClassUtils.getMostSpecificMethod(candidate, information.getRepositoryInterface());
        }
        if (ClassUtils.hasMethod(information.getRepositoryInterface(), FIND_ALL, new Class[0])) {
            return ClassUtils.getMostSpecificMethod(ReflectionUtils.findMethod(CrudRepository.class, FIND_ALL), information.getRepositoryInterface());
        }
        return null;
    }

    private Method selectMostSuitableFindOneMethod(RepositoryInformation information) {
        for (Class type : Arrays.asList(information.getIdType(), Serializable.class)) {
            Method candidate = ReflectionUtils.findMethod(information.getRepositoryInterface(), FIND_ONE, type);
            if (candidate == null) continue;
            return ClassUtils.getMostSpecificMethod(candidate, information.getRepositoryInterface());
        }
        return null;
    }

    @Override
    public Method getSaveMethod() {
        return this.saveMethod;
    }

    @Override
    public boolean hasSaveMethod() {
        return this.saveMethod != null;
    }

    @Override
    public Method getFindAllMethod() {
        return this.findAllMethod;
    }

    @Override
    public boolean hasFindAllMethod() {
        return this.findAllMethod != null;
    }

    @Override
    public Method getFindOneMethod() {
        return this.findOneMethod;
    }

    @Override
    public boolean hasFindOneMethod() {
        return this.findOneMethod != null;
    }

    @Override
    public boolean hasDelete() {
        return this.deleteMethod != null;
    }

    @Override
    public Method getDeleteMethod() {
        return this.deleteMethod;
    }
}

