/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.QueryExtractor;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.query.QueryCreationException;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;

final class NamedQuery
extends AbstractJpaQuery {
    private static final String CANNOT_EXTRACT_QUERY = "Your persistence provider does not support extracting the JPQL query from a named query thus you can't use Pageable inside your query method. Make sure you have a JpaDialect configured at your EntityManagerFactoryBean as this affects discovering the concrete persistence provider.";
    private static final Logger LOG = LoggerFactory.getLogger(NamedQuery.class);
    private final String queryName;
    private final String countQueryName;
    private final QueryExtractor extractor;

    private NamedQuery(JpaQueryMethod method, EntityManager em) {
        super(method, em);
        boolean cantExtractQuery;
        this.queryName = method.getNamedQueryName();
        this.countQueryName = method.getNamedCountQueryName();
        this.extractor = method.getQueryExtractor();
        JpaParameters parameters = method.getParameters();
        em.createNamedQuery(this.queryName);
        if (parameters.hasSortParameter()) {
            throw new IllegalStateException(String.format("Finder method %s is backed by a NamedQuery and must not contain a sort parameter as we cannot modify the query! Use @Query instead!", method));
        }
        boolean weNeedToCreateCountQuery = !NamedQuery.hasNamedQuery(em, this.countQueryName) && method.getParameters().hasPageableParameter();
        boolean bl = cantExtractQuery = !this.extractor.canExtractQuery();
        if (weNeedToCreateCountQuery && cantExtractQuery) {
            throw QueryCreationException.create((QueryMethod)method, CANNOT_EXTRACT_QUERY);
        }
        if (parameters.hasPageableParameter()) {
            LOG.warn("Finder method {} is backed by a NamedQuery but contains a Pageable parameter! Sorting delivered via this Pageable will not be applied!", (Object)method);
        }
    }

    private static boolean hasNamedQuery(EntityManager em, String queryName) {
        try {
            em.createNamedQuery(queryName);
            return true;
        }
        catch (IllegalArgumentException e2) {
            LOG.debug("Did not find named query {}", (Object)queryName);
            return false;
        }
    }

    public static RepositoryQuery lookupFrom(JpaQueryMethod method, EntityManager em) {
        String queryName = method.getNamedQueryName();
        LOG.debug("Looking up named query {}", (Object)queryName);
        try {
            NamedQuery query2 = new NamedQuery(method, em);
            LOG.debug("Found named query {}!", (Object)queryName);
            return query2;
        }
        catch (IllegalArgumentException e2) {
            return null;
        }
    }

    @Override
    protected Query doCreateQuery(Object[] values) {
        Query query2 = this.getEntityManager().createNamedQuery(this.queryName);
        return this.createBinder(values).bindAndPrepare(query2);
    }

    @Override
    protected TypedQuery<Long> doCreateCountQuery(Object[] values) {
        EntityManager em = this.getEntityManager();
        TypedQuery<Long> countQuery = null;
        if (NamedQuery.hasNamedQuery(em, this.countQueryName)) {
            countQuery = em.createNamedQuery(this.countQueryName, Long.class);
        } else {
            Query query2 = this.createQuery(values);
            String queryString = this.extractor.extractQueryString(query2);
            countQuery = em.createQuery(QueryUtils.createCountQueryFor(queryString), Long.class);
        }
        return this.createBinder(values).bind(countQuery);
    }
}

