/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JDBCExceptionReporter {
    public static final Logger log = LoggerFactory.getLogger(JDBCExceptionReporter.class);
    public static final String DEFAULT_EXCEPTION_MSG = "SQL Exception";
    public static final String DEFAULT_WARNING_MSG = "SQL Warning";
    public static StandardWarningHandler STANDARD_WARNING_HANDLER = new StandardWarningHandler("SQL Warning");

    private JDBCExceptionReporter() {
    }

    public static void logAndClearWarnings(Connection connection) {
        JDBCExceptionReporter.handleAndClearWarnings(connection, (WarningHandler)STANDARD_WARNING_HANDLER);
    }

    public static void handleAndClearWarnings(Connection connection, WarningHandler handler) {
        try {
            JDBCExceptionReporter.walkWarnings(connection.getWarnings(), handler);
        }
        catch (SQLException sqle) {
            log.debug("could not log warnings", sqle);
        }
        try {
            connection.clearWarnings();
        }
        catch (SQLException sqle) {
            log.debug("could not clear warnings", sqle);
        }
    }

    public static void handleAndClearWarnings(Statement statement, WarningHandler handler) {
        try {
            JDBCExceptionReporter.walkWarnings(statement.getWarnings(), handler);
        }
        catch (SQLException sqle) {
            log.debug("could not log warnings", sqle);
        }
        try {
            statement.clearWarnings();
        }
        catch (SQLException sqle) {
            log.debug("could not clear warnings", sqle);
        }
    }

    @Deprecated
    public static void logWarnings(SQLWarning warning) {
        JDBCExceptionReporter.walkWarnings(warning, STANDARD_WARNING_HANDLER);
    }

    @Deprecated
    public static void logWarnings(SQLWarning warning, String message) {
        StandardWarningHandler handler = StringHelper.isNotEmpty(message) ? new StandardWarningHandler(message) : STANDARD_WARNING_HANDLER;
        JDBCExceptionReporter.walkWarnings(warning, handler);
    }

    public static void walkWarnings(SQLWarning warning, WarningHandler handler) {
        if (warning == null || handler.doProcess()) {
            return;
        }
        handler.prepare(warning);
        while (warning != null) {
            handler.handleWarning(warning);
            warning = warning.getNextWarning();
        }
    }

    public static void logExceptions(SQLException ex) {
        JDBCExceptionReporter.logExceptions(ex, null);
    }

    public static void logExceptions(SQLException ex, String message) {
        if (log.isErrorEnabled()) {
            if (log.isDebugEnabled()) {
                message = StringHelper.isNotEmpty(message) ? message : DEFAULT_EXCEPTION_MSG;
                log.debug(message, ex);
            }
            while (ex != null) {
                StringBuffer buf = new StringBuffer(30).append("SQL Error: ").append(ex.getErrorCode()).append(", SQLState: ").append(ex.getSQLState());
                log.warn(buf.toString());
                log.error(ex.getMessage());
                ex = ex.getNextException();
            }
        }
    }

    public static class StandardWarningHandler
    extends WarningHandlerLoggingSupport {
        private final String introMessage;

        public StandardWarningHandler(String introMessage) {
            this.introMessage = introMessage;
        }

        public boolean doProcess() {
            return log.isWarnEnabled();
        }

        public void prepare(SQLWarning warning) {
            log.debug(this.introMessage, warning);
        }

        protected void logWarning(String description, String message) {
            log.warn(description);
            log.warn(message);
        }
    }

    public static abstract class WarningHandlerLoggingSupport
    implements WarningHandler {
        public final void handleWarning(SQLWarning warning) {
            StringBuffer buf = new StringBuffer(30).append("SQL Warning Code: ").append(warning.getErrorCode()).append(", SQLState: ").append(warning.getSQLState());
            this.logWarning(buf.toString(), warning.getMessage());
        }

        protected abstract void logWarning(String var1, String var2);
    }

    public static interface WarningHandler {
        public boolean doProcess();

        public void prepare(SQLWarning var1);

        public void handleWarning(SQLWarning var1);
    }
}

