/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.hibernate.util.ReflectHelper;

public abstract class Callback
implements Serializable {
    protected transient Method callbackMethod;

    public Callback(Method callbackMethod) {
        this.callbackMethod = callbackMethod;
    }

    public Method getCallbackMethod() {
        return this.callbackMethod;
    }

    public abstract void invoke(Object var1);

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.callbackMethod.toGenericString());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        String signature = (String)ois.readObject();
        StringTokenizer st = new StringTokenizer(signature, " ", false);
        String usefulSignature = null;
        while (st.hasMoreElements()) {
            usefulSignature = (String)st.nextElement();
        }
        int parenthesis = usefulSignature.indexOf("(");
        String methodAndClass = usefulSignature.substring(0, parenthesis);
        int lastDot = methodAndClass.lastIndexOf(".");
        String clazzName = methodAndClass.substring(0, lastDot);
        Class callbackClass = ReflectHelper.classForName(clazzName, this.getClass());
        String parametersString = usefulSignature.substring(parenthesis + 1, usefulSignature.length() - 1);
        st = new StringTokenizer(parametersString, ", ", false);
        ArrayList<Class> parameters = new ArrayList<Class>();
        while (st.hasMoreElements()) {
            String parameter = (String)st.nextElement();
            parameters.add(ReflectHelper.classForName(parameter, this.getClass()));
        }
        String methodName = methodAndClass.substring(lastDot + 1, methodAndClass.length());
        try {
            this.callbackMethod = callbackClass.getDeclaredMethod(methodName, parameters.toArray(new Class[parameters.size()]));
            if (!this.callbackMethod.isAccessible()) {
                this.callbackMethod.setAccessible(true);
            }
        }
        catch (NoSuchMethodException e2) {
            throw new IOException("Unable to get EJB3 callback method: " + signature + ", cause: " + e2);
        }
    }
}

