/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.OptimisticLockException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.action.EntityVerifyVersionProcess;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.persister.entity.Lockable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimisticLockingStrategy
implements LockingStrategy {
    private static final Logger log = LoggerFactory.getLogger(OptimisticLockingStrategy.class);
    private final Lockable lockable;
    private final LockMode lockMode;

    public OptimisticLockingStrategy(Lockable lockable, LockMode lockMode) {
        this.lockable = lockable;
        this.lockMode = lockMode;
        if (lockMode.lessThan(LockMode.OPTIMISTIC)) {
            throw new HibernateException("[" + lockMode + "] not valid for [" + lockable.getEntityName() + "]");
        }
    }

    public void lock(Serializable id, Object version2, Object object, int timeout, SessionImplementor session) throws StaleObjectStateException, JDBCException {
        if (!this.lockable.isVersioned()) {
            throw new OptimisticLockException("[" + this.lockMode + "] not supported for non-versioned entities [" + this.lockable.getEntityName() + "]");
        }
        EntityEntry entry = session.getPersistenceContext().getEntry(object);
        EventSource source = (EventSource)session;
        EntityVerifyVersionProcess verifyVersion = new EntityVerifyVersionProcess(object, entry);
        source.getActionQueue().registerProcess(verifyVersion);
    }

    protected LockMode getLockMode() {
        return this.lockMode;
    }
}

