/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication.auditor.v1.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import org.dataone.service.cn.replication.auditor.v1.strategy.CoordinatingNodeReplicaAuditingStrategy;
import org.dataone.service.cn.replication.auditor.v1.strategy.ReplicaAuditStrategy;
import org.dataone.service.types.v1.Identifier;

public class CoordinatingNodeReplicaAuditTask
implements Serializable,
Callable<String> {
    private static final long serialVersionUID = 8549092026722882706L;
    private List<Identifier> pidsToAudit = new ArrayList<Identifier>();
    private ReplicaAuditStrategy auditor;
    private Date auditDate;

    public CoordinatingNodeReplicaAuditTask(List<Identifier> pids, Date auditDate) {
        this.pidsToAudit.addAll(pids);
        this.auditDate = auditDate;
        this.auditor = new CoordinatingNodeReplicaAuditingStrategy();
    }

    @Override
    public String call() throws Exception {
        this.auditor.auditPids(this.pidsToAudit, this.auditDate);
        return "Replica audit task for pids: " + this.pidsToAudit.size() + " completed.";
    }

    public List<Identifier> getPidsToAudit() {
        return this.pidsToAudit;
    }
}

