/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication.auditor.v1.strategy;

import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dataone.client.D1NodeFactory;
import org.dataone.client.rest.HttpMultipartRestClient;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.cn.log.AuditEvent;
import org.dataone.cn.log.AuditLogClientFactory;
import org.dataone.cn.log.AuditLogEntry;
import org.dataone.configuration.Settings;
import org.dataone.service.cn.replication.auditor.v1.strategy.ReplicaAuditStrategy;
import org.dataone.service.cn.replication.auditor.v1.strategy.ReplicaAuditingDelegate;
import org.dataone.service.cn.v2.NodeRegistryService;
import org.dataone.service.cn.v2.impl.NodeRegistryServiceImpl;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Node;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.util.ChecksumUtil;
import org.dataone.service.types.v2.SystemMetadata;

public class CoordinatingNodeReplicaAuditingStrategy
implements ReplicaAuditStrategy {
    public static Logger log = Logger.getLogger(CoordinatingNodeReplicaAuditingStrategy.class);
    private static final BigInteger auditSizeLimit = Settings.getConfiguration().getBigInteger("dataone.cn.audit.size.limit", BigInteger.valueOf(10000000L));
    private ReplicaAuditingDelegate auditDelegate = new ReplicaAuditingDelegate();
    private Map<NodeReference, CNode> cnMap = new HashMap<NodeReference, CNode>();
    private NodeRegistryService nodeService = new NodeRegistryServiceImpl();

    @Override
    public void auditPids(List<Identifier> pids, Date auditDate) {
        log.debug("audit pids called with " + pids.size() + ".");
        for (Identifier pid : pids) {
            this.auditPid(pid, auditDate);
        }
    }

    private void auditPid(Identifier pid, Date auditDate) {
        log.debug("auditPid for Coordinating Node replica called for pid: " + pid.getValue());
        AuditLogClientFactory.getAuditLogClient().removeReplicaAuditEvent(new AuditLogEntry(pid.getValue(), this.auditDelegate.getCnRouterId(), AuditEvent.REPLICA_AUDIT_FAILED, null, null));
        SystemMetadata sysMeta = this.auditDelegate.getSystemMetadata(pid);
        if (sysMeta == null) {
            return;
        }
        for (Replica replica : sysMeta.getReplicaList()) {
            if (!this.auditDelegate.isCNodeReplica(replica)) continue;
            this.auditCNodeReplicas(sysMeta, replica);
            break;
        }
    }

    private void auditCNodeReplicas(org.dataone.service.types.v1.SystemMetadata sysMeta, Replica replica) {
        try {
            for (Node node : this.nodeService.listNodes().getNodeList()) {
                String message;
                CNode cn;
                if (!NodeType.CN.equals(node.getType()) || this.auditDelegate.getCnRouterId().equals(node.getIdentifier().getValue()) || (cn = this.getCNode(node)) == null) continue;
                if (auditSizeLimit.compareTo(sysMeta.getSize()) < 0) {
                    this.logReplicaAuditFailure(sysMeta.getIdentifier().getValue(), cn.getNodeId().getValue(), AuditEvent.REPLICA_AUDIT_FAILED, "replica audit skipped, size of document exceeds audit limit");
                    this.updateReplicaVerified(sysMeta.getIdentifier(), replica);
                    continue;
                }
                Checksum expected = sysMeta.getChecksum();
                Checksum actual = null;
                boolean thisValid = true;
                try {
                    actual = this.calculateCNChecksum(cn, sysMeta);
                }
                catch (NotFound e2) {
                    thisValid = false;
                    message = "Attempt to retrieve the pid: " + sysMeta.getIdentifier().getValue() + " from CN: " + node.getIdentifier().getValue() + " resulted in a D1 NotFound exception: " + e2.getMessage() + ".   Replica has NOT been marked invalid.";
                    log.error(message, e2);
                    this.logReplicaAuditFailure(sysMeta.getIdentifier().getValue(), node.getIdentifier().getValue(), AuditEvent.REPLICA_NOT_FOUND, message);
                    continue;
                }
                catch (NotAuthorized e3) {
                    thisValid = false;
                    message = "Attempt to retrieve pid: " + sysMeta.getIdentifier().getValue() + " from CN: " + node.getIdentifier().getValue() + " resulted in a D1 NotAuthorized exception: " + e3.getMessage() + ".   Replica has NOT been marked invalid.";
                    log.error(message, e3);
                    this.logReplicaAuditFailure(sysMeta.getIdentifier().getValue(), node.getIdentifier().getValue(), AuditEvent.REPLICA_AUDIT_FAILED, message);
                    continue;
                }
                catch (NotImplemented e4) {
                    thisValid = false;
                    message = "Attempt to retrieve pid: " + sysMeta.getIdentifier().getValue() + " from CN: " + node.getIdentifier().getValue() + " resulted in a D1 NotImplemented exception: " + e4.getMessage() + ".   Replica has NOT been marked invalid.";
                    log.error(message, e4);
                    this.logReplicaAuditFailure(sysMeta.getIdentifier().getValue(), node.getIdentifier().getValue(), AuditEvent.REPLICA_AUDIT_FAILED, message);
                    continue;
                }
                catch (InvalidToken e5) {
                    thisValid = false;
                    message = "Attempt to retrieve pid: " + sysMeta.getIdentifier().getValue() + " from CN: " + node.getIdentifier().getValue() + " resulted in a D1 InvalidToken exception: " + e5.getMessage() + ".   Replica has NOT been marked invalid.";
                    log.error(message, e5);
                    this.logReplicaAuditFailure(sysMeta.getIdentifier().getValue(), node.getIdentifier().getValue(), AuditEvent.REPLICA_AUDIT_FAILED, message);
                    continue;
                }
                catch (ServiceFailure e6) {
                    thisValid = false;
                    message = "Attempt to retrieve pid: " + sysMeta.getIdentifier().getValue() + " from CN: " + node.getIdentifier().getValue() + " resulted in a D1 ServiceFailure exception: " + e6.getMessage() + ".   Replica has NOT been marked invalid.";
                    log.error(message, e6);
                    this.logReplicaAuditFailure(sysMeta.getIdentifier().getValue(), node.getIdentifier().getValue(), AuditEvent.REPLICA_AUDIT_FAILED, message);
                    continue;
                }
                if (actual != null && thisValid) {
                    thisValid = ChecksumUtil.areChecksumsEqual(expected, actual);
                }
                if (thisValid) {
                    AuditLogClientFactory.getAuditLogClient().removeReplicaAuditEvent(new AuditLogEntry(sysMeta.getIdentifier().getValue(), node.getIdentifier().getValue(), null, null, null));
                    continue;
                }
                String message2 = "Checksum mismatch for pid: " + sysMeta.getIdentifier().getValue() + " against CN: " + node.getIdentifier().getValue() + ".  Expected checksum is: " + expected.getValue() + ". ";
                if (actual != null) {
                    message2 = message2 + " actual was: " + actual.getValue() + ". ";
                }
                message2 = message2 + "Replica has NOT been marked invalid.";
                log.error(message2);
                this.logReplicaAuditFailure(sysMeta.getIdentifier().getValue(), node.getIdentifier().getValue(), AuditEvent.REPLICA_BAD_CHECKSUM, message2);
            }
        }
        catch (NotImplemented e7) {
            log.error("Unable to get node list from node registry service", e7);
            e7.printStackTrace();
        }
        catch (ServiceFailure e8) {
            log.error("UNable to get node list from node registry service", e8);
            e8.printStackTrace();
        }
        this.updateReplicaVerified(sysMeta.getIdentifier(), replica);
    }

    private void logReplicaAuditFailure(String pid, String nodeId, AuditEvent event, String message) {
        AuditLogClientFactory.getAuditLogClient().removeReplicaAuditEvent(new AuditLogEntry(pid, nodeId, event, null, null));
        AuditLogEntry logEntry = new AuditLogEntry(pid, nodeId, event, message);
        AuditLogClientFactory.getAuditLogClient().logAuditEvent(logEntry);
    }

    private void updateReplicaVerified(Identifier pid, Replica replica) {
        this.auditDelegate.updateVerifiedReplica(pid, replica);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Checksum calculateCNChecksum(CNode cn, org.dataone.service.types.v1.SystemMetadata sysmeta) throws NotFound, InvalidToken, ServiceFailure, NotAuthorized, NotImplemented {
        Checksum checksum = null;
        String algorithm = sysmeta.getChecksum().getAlgorithm();
        InputStream is = cn.get(null, sysmeta.getIdentifier());
        if (is != null) {
            try {
                checksum = ChecksumUtil.checksum(is, algorithm);
            }
            catch (Exception e2) {
                log.error("Cannot calculate CN checksum for id: " + sysmeta.getIdentifier().getValue(), e2);
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        } else {
            log.error("Could not calculate checksum on CN, unable to get object bytes");
        }
        return checksum;
    }

    private CNode getCNode(Node node) {
        if (!this.cnMap.containsKey(node.getIdentifier().getValue())) {
            CNode cn = null;
            try {
                cn = D1Client.getCN();
            }
            catch (BaseException e2) {
                log.warn("Caught a ServiceFailure while getting a reference to the CN ", e2);
                try {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        log.error("There was a problem getting a Coordinating Node reference.", e1);
                    }
                    cn = D1Client.getCN();
                }
                catch (BaseException e1) {
                    log.warn("Second ServiceFailure while getting a reference to the CN", e1);
                    try {
                        log.warn("...Building CNode without baseURL check.");
                        cn = D1NodeFactory.buildNode(CNode.class, new HttpMultipartRestClient(), URI.create(Settings.getConfiguration().getString("D1Client.CN_URL")));
                    }
                    catch (Exception e22) {
                        log.error("ClientSideException trying to build a CNode.", e22);
                        cn = null;
                    }
                }
            }
            if (cn != null) {
                this.cnMap.put(node.getIdentifier(), cn);
            }
        }
        return this.cnMap.get(node.getIdentifier());
    }
}

