/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.configuration.ConversionException;
import org.apache.log4j.Logger;
import org.dataone.client.v1.CNode;
import org.dataone.client.v1.itk.D1Client;
import org.dataone.cn.ComponentActivationUtility;
import org.dataone.cn.dao.DaoFactory;
import org.dataone.cn.dao.ReplicationDao;
import org.dataone.cn.dao.exceptions.DataAccessException;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.configuration.Settings;
import org.dataone.service.cn.replication.ReplicationCommunication;
import org.dataone.service.cn.replication.ReplicationFactory;
import org.dataone.service.cn.replication.ReplicationService;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v2.SystemMetadata;

public class StaleReplicationRequestAuditor
implements Runnable {
    private static Logger log = Logger.getLogger(StaleReplicationRequestAuditor.class);
    private static ReplicationService replicationService = ReplicationFactory.getReplicationService();
    private static final String STALE_REPLICATION_LOCK_NAME = "staleReplicationAuditingLock";
    private static HazelcastInstance hzClient = HazelcastClientFactory.getProcessingClient();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (ComponentActivationUtility.replicationIsActive()) {
            boolean isLocked = false;
            ILock lock = hzClient.getLock(STALE_REPLICATION_LOCK_NAME);
            try {
                isLocked = lock.tryLock();
                if (isLocked) {
                    log.debug("Stale Replication Request Auditor running.");
                    this.processStaleRequests();
                    log.debug("Stale Replication Request Auditor finished.");
                }
            }
            catch (Exception e2) {
                log.error("Error processing stale requested replicas:", e2);
            }
            finally {
                if (isLocked) {
                    lock.unlock();
                }
            }
        }
    }

    private void processStaleRequests() {
        CNode cn = this.getCNode();
        if (cn != null) {
            List<ReplicationDao.ReplicaDto> requestedReplicas = this.getReplicasToAudit();
            for (ReplicationDao.ReplicaDto result : requestedReplicas) {
                Identifier identifier = result.identifier;
                NodeReference nodeId = result.replica.getReplicaMemberNode();
                SystemMetadata sysmeta = null;
                try {
                    sysmeta = replicationService.getSystemMetadata(identifier);
                }
                catch (NotFound e2) {
                    log.error("Cannot find system metadata for pid: " + identifier.getValue());
                    continue;
                }
                if (sysmeta == null) continue;
                ReplicationCommunication rc = ReplicationCommunication.getInstance(nodeId);
                Checksum mnChecksum = null;
                try {
                    mnChecksum = rc.getChecksumFromMN(identifier, nodeId, sysmeta);
                }
                catch (BaseException e3) {
                    log.warn(e3.getMessage());
                }
                if (mnChecksum == null) {
                    this.deleteReplica(identifier, nodeId);
                    continue;
                }
                this.updateReplicaToComplete(cn, identifier, nodeId, sysmeta);
            }
        }
    }

    private Date calculateAuditDate() {
        int auditSecondsBeforeNow = -3600;
        try {
            auditSecondsBeforeNow = Settings.getConfiguration().getInt("replication.audit.pending.window");
        }
        catch (ConversionException ce) {
            log.error("Couldn't convert the replication.audit.pending.window property correctly: " + ce.getMessage(), ce);
        }
        Calendar cal = Calendar.getInstance();
        cal.add(13, auditSecondsBeforeNow);
        Date auditDate = cal.getTime();
        return auditDate;
    }

    private List<ReplicationDao.ReplicaDto> getReplicasToAudit() {
        Date auditDate = this.calculateAuditDate();
        List<Object> requestedReplicas = new ArrayList();
        try {
            requestedReplicas = DaoFactory.getReplicationDao().getRequestedReplicasByDate(auditDate);
        }
        catch (DataAccessException e2) {
            e2.printStackTrace();
        }
        log.debug("Stale Replication Request Auditor - pendingReplicasByDate size is " + requestedReplicas.size());
        return requestedReplicas;
    }

    private CNode getCNode() {
        CNode cn;
        block2: {
            cn = null;
            try {
                cn = D1Client.getCN();
            }
            catch (BaseException e2) {
                log.error("Couldn't connect to the CN to manage replica states: " + e2.getMessage());
                if (!log.isDebugEnabled()) break block2;
                e2.printStackTrace();
            }
        }
        return cn;
    }

    private void updateReplicaToComplete(CNode cn, Identifier identifier, NodeReference nodeId, SystemMetadata sysmeta) {
        Replica replicaToUpdate = null;
        for (Replica replica : sysmeta.getReplicaList()) {
            if (!replica.getReplicaMemberNode().getValue().equals(nodeId.getValue())) continue;
            replicaToUpdate = replica;
            break;
        }
        if (replicaToUpdate != null) {
            log.debug("Stale Replication Request Auditor setting replica complete for pid: " + identifier.getValue() + " for target mn: " + nodeId);
            replicationService.setReplicaToCompleted(identifier, nodeId);
        }
    }

    private void deleteReplica(Identifier identifier, NodeReference nodeRef) {
        replicationService.deleteReplicationMetadata(identifier, nodeRef);
    }
}

