/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.dataone.cn.ComponentActivationUtility;
import org.dataone.cn.dao.DaoFactory;
import org.dataone.cn.dao.ReplicationDao;
import org.dataone.cn.dao.exceptions.DataAccessException;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.service.cn.replication.ReplicationFactory;
import org.dataone.service.cn.replication.ReplicationTaskQueue;
import org.dataone.service.types.v1.NodeReference;

public class QueuedReplicationAuditor
implements Runnable {
    private static Logger log = Logger.getLogger(QueuedReplicationAuditor.class);
    private ReplicationTaskQueue replicationTaskQueue = ReplicationFactory.getReplicationTaskQueue();
    private ReplicationDao replicationDao = DaoFactory.getReplicationDao();
    private static final String QUEUED_REPLICATION_LOCK_NAME = "queuedReplicationAuditingLock";
    private static HazelcastInstance hzClient = HazelcastClientFactory.getProcessingClient();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (ComponentActivationUtility.replicationIsActive()) {
            boolean isLocked = false;
            ILock lock = hzClient.getLock(QUEUED_REPLICATION_LOCK_NAME);
            try {
                isLocked = lock.tryLock();
                if (isLocked) {
                    log.debug("Queued Request Auditor running.");
                    this.runQueuedTasks();
                    log.debug("Queued Replication Auditor finished.");
                }
            }
            catch (Exception e2) {
                log.error("Error processing queued replicas:", e2);
            }
            finally {
                if (isLocked) {
                    lock.unlock();
                }
            }
        }
    }

    private void runQueuedTasks() {
        Collection<NodeReference> nodes = this.replicationTaskQueue.getMemberNodesInQueue();
        for (NodeReference nodeRef : nodes) {
            int sizeOfQueue = this.replicationTaskQueue.getCountOfTasksForNode(nodeRef.getValue());
            log.debug("Queued tasks for member node: " + nodeRef.getValue() + " has: " + sizeOfQueue + " tasks in queue.");
            if (sizeOfQueue <= 0) continue;
            int sizeOfRequested = this.getRequestedCount(nodeRef);
            log.debug("Queued Auditor report for mn: " + nodeRef.getValue() + " has: " + sizeOfRequested + " requested replicas and: " + sizeOfQueue + " requested replicas.");
            this.replicationTaskQueue.processAllTasksForMN(nodeRef.getValue());
        }
    }

    private int getRequestedCount(NodeReference nodeRef) {
        int sizeOfRequested = -1;
        try {
            sizeOfRequested = this.replicationDao.getRequestedReplicationCount(nodeRef);
        }
        catch (DataAccessException e2) {
            log.error("Unable to get oustanding rplication count for mn: " + nodeRef.getValue(), e2);
        }
        return sizeOfRequested;
    }
}

